package ru.yandex.autotests.direct.api.adgroups.update.dynamictextfeedadgroup;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 11.08.16.
 * https://st.yandex-team.ru/TESTIRT-10035
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Stories(AdGroupsStories.DYNAMIC_TEXT_FEED)
@Issue("https://st.yandex-team.ru/DIRECT-55195")
@Description("Проверка невозможности задать DomainUrl для ДО-группы с фидом")
public class DynamicTextFeedAddGroupUpdateDomainUrlTest {
    private static final String LOGIN = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long adGroupId;

    @BeforeClass
    public static void initTest() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(campaignId);
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        Long feedId = jooqDbSteps.feedsSteps().createDefaultFeed(User.get(LOGIN).getClientID());
        jooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(adGroupId, feedId);
    }

    @Test
    public void updateDomain() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withDynamicTextAdGroup(new DynamicTextAdGroupMap()
                                .withDomainUrl(DynamicTextAdGroupMap.DEFAULT_DOMAIN_URL)
                        )
                ),
                ExpectedResult.errors(
                    new Notification(6000, Api5ErrorDetails.ADGROUP_SUBTYPE_NOT_MATCHES_WITH_TYPE_IN_REQUEST)
                )
        );
    }

}
