package ru.yandex.autotests.direct.api.adgroups.update.dynamictextfeedadgroup;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.Phrases;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsDynamicRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.GroupParamsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.DynamicTextAdGroupMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.beanfield.BeanFieldPath;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 29.09.16.
 * https://st.yandex-team.ru/TESTIRT-10266
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Description("Обновление динамических групп и проверка их состояния в базе")
@Issue("https://st.yandex-team.ru/DIRECT-58442")
public class UpdateAdGroupAndCheckDBTest {
    private static final String CLIENT = AdGroupsLogins.CLIENT;
    private static Long adGroupId;
    private static PhrasesRecord phrasesBeforeUpdate;
    private static GroupParamsRecord groupParamsBeforeUpdate;
    private static PhrasesRecord phrasesAfterUpdate;
    private static GroupParamsRecord groupParamsAfterUpdate;
    private static AdgroupsDynamicRecord adGroupsDynamicBeforeUpdate;
    private static AdgroupsDynamicRecord adGroupsDynamicAfterUpdate;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

    @BeforeClass
    public static void prepareData(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long feedId = directJooqDbSteps.feedsSteps().createDefaultFeed(User.get(CLIENT).getClientID());
        Long campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .defaultAdGroupAddItem(campaignId)
                .withDynamicTextAdGroup(new DynamicTextAdGroupMap().defaultGroup())
                .withTrackingParams(AdGroupAddItemMap.DEFAULT_TRACKING_PARAMS)
                .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD)
        );

        directJooqDbSteps.adGroupsSteps().convertAdgroupDynamicToDynamicByFeed(adGroupId, feedId);

        phrasesBeforeUpdate = directJooqDbSteps.adGroupsSteps().getPhrases(adGroupId);
        groupParamsBeforeUpdate = directJooqDbSteps.adGroupsSteps().getGroupParams(adGroupId);
        adGroupsDynamicBeforeUpdate = directJooqDbSteps.adGroupsSteps().getAdgroupsDynamic(adGroupId);

        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME + "Updated")),
                ExpectedResult.success()
        );

        phrasesAfterUpdate = directJooqDbSteps.adGroupsSteps().getPhrases(adGroupId);
        groupParamsAfterUpdate = directJooqDbSteps.adGroupsSteps().getGroupParams(adGroupId);
        adGroupsDynamicAfterUpdate = directJooqDbSteps.adGroupsSteps().getAdgroupsDynamic(adGroupId);
    }

    @Test
    public void checkPpcPhrasesAfterUpdateAdGroup(){
        assertThat("в группе не изменилось ничего лишнего",
                phrasesAfterUpdate.intoMap(), beanDiffer(phrasesBeforeUpdate.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.allFieldsExcept(
                                BeanFieldPath.newPath(Phrases.PHRASES.LASTCHANGE.getName()),
                                BeanFieldPath.newPath(Phrases.PHRASES.GROUP_NAME.getName())
                        )));
    }

    @Test
    public void checkPpcGroupParamsAfterUpdateAdGroup(){
        assertThat("в группе не изменилось ничего лишнего",
                groupParamsAfterUpdate.intoMap(), beanDiffer(groupParamsBeforeUpdate.intoMap()));
    }

    @Test
    public void checkPpcAdGroupsDynamicAfterUpdateAdGroup(){
        assertThat("в группе не изменилось ничего лишнего",
                adGroupsDynamicAfterUpdate.intoMap(), beanDiffer(adGroupsDynamicBeforeUpdate.intoMap()));
    }

}

