package ru.yandex.autotests.direct.api.adgroups.update.mobileappadgroups;

import com.yandex.direct.api.v5.adgroups.TargetCarrierEnum;
import com.yandex.direct.api.v5.adgroups.TargetDeviceTypeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.OSVersions;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupUpdateMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Author buhter
 * Date 17.09.15
 * https://st.yandex-team.ru/TESTIRT-7178
 * https://st.yandex-team.ru/TESTIRT-8657
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Stories(AdGroupsStories.MOBILE)
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
public class MobileAppAdGroupUpdateAndCheckStatusBsSynced {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    Long adGroupId;

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        Integer campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign().intValue();
        adGroupId = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .defaultAdGroupAddItem(campaignId.longValue())
                .withMobileAppAdGroup(
                        new MobileAppAdGroupAddMap().defaultGroup()
                                .withTargetCarrier(TargetCarrierEnum.WI_FI_AND_CELLULAR)
                                .withTargetOperatingSystemVersion(OSVersions.ANDRIOD_VERSIONS[0])
                                .withTargetDeviceTypes(TargetDeviceTypeEnum.DEVICE_TYPE_TABLET)
                )
                .withTrackingParams(AdGroupAddItemMap.DEFAULT_TRACKING_PARAMS)
        );
        api.userSteps.groupFakeSteps().setGroupFakeStatusBsSynced(adGroupId, Status.YES);
        api.userSteps.groupFakeSteps().setStatusModerate(adGroupId, Status.YES);
        GroupFakeInfo groupBeforeUpdate = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assumeThat("группе установился нужный статус синхронизации с БК",
                groupBeforeUpdate.getStatusBsSynced(), equalTo(Status.YES));
    }

    @Test
    public void updateTargetCarrier() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withMobileAppAdGroup(new MobileAppAdGroupUpdateMap()
                                .withTargetCarrier(TargetCarrierEnum.WI_FI_ONLY))
                ));
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assertThat("статус синхронизации с БК обновился", groupFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }

    @Test
    public void updateTargetOperatingSystemVersion() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withMobileAppAdGroup(new MobileAppAdGroupUpdateMap()
                                .withTargetOperatingSystemVersion(OSVersions.ANDRIOD_VERSIONS[1]))
                ));
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assertThat("статус синхронизации с БК обновился", groupFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }

    @Test
    public void updateTargetDeviceTypes() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withMobileAppAdGroup(new MobileAppAdGroupUpdateMap()
                                .withTargetDeviceTypes(TargetDeviceTypeEnum.DEVICE_TYPE_MOBILE)
                        )
                ));
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assertThat("статус синхронизации с БК обновился", groupFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }

    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-51468#1457351722000")
    public void updateTrackingParams() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withTrackingParams(AdGroupAddItemMap.DEFAULT_TRACKING_PARAMS + "api")
                ));
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupId);
        assertThat("статус синхронизации с БК обновился", groupFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }
}
