package ru.yandex.autotests.direct.api.adgroups.update.mobileappadgroups;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsMobileContentRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins.CLIENT;

@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Stories(AdGroupsStories.MOBILE)
public class MobileAppAdGroupUpdateNegativeTest {
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps()
            .useShardForLogin(CLIENT);

    private long campaignId;

    @Before
    public void setUp() {
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(CLIENT);
    }

    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-87163")
    public void updateAdGroupsWithWrongDomainInDatabase_expectError() {
        long adGroupId = api.userSteps.adGroupsSteps().addDefaultMobileGroup(campaignId);
        AdgroupsMobileContentRecord record = directJooqDbSteps.adGroupsSteps().getAdGroupMobileContent(adGroupId);
        record.setStoreContentHref(record.getStoreContentHref() + "&test={TEST}");
        directJooqDbSteps.adGroupsSteps().updateAdGroupMobileContent(record);
        api.userSteps.adGroupsSteps().expectErrorOnAdGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME + "Updated")),
                new Api5Error(1005));
    }
}
