package ru.yandex.autotests.direct.api.adgroups.update.mobileappadgroups;

import com.yandex.direct.api.v5.adgroups.TargetCarrierEnum;
import com.yandex.direct.api.v5.adgroups.TargetDeviceTypeEnum;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileAppsRecord;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.OSVersions;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupUpdateMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Stories;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Stories(AdGroupsStories.MOBILE)
@Issue("https://st.yandex-team.ru/DIRECT-82971")
@Description("Проверка обновление группы в кампанию, где есть привязанное приложение")
public class MobileAppAdGroupUpdateNewRmpAndCheckAppOnCampaign {
    private static final String CLIENT = AdGroupsLogins.CLIENT_NEW_RMP;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long clientId;
    private MobileAppsRecord mobileApp;
    private long campaignId;
    private Long adGroupId;

    @Before
    public void before() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);

        clientId = Long.valueOf(User.get(CLIENT).getClientID());

        mobileApp = getAnyClientApp();
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).campaignsSteps()
                .setCampaignMobileAppId(campaignId, mobileApp.getMobileAppId());

        adGroupId = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .defaultAdGroupAddItem(campaignId)
                        .withMobileAppAdGroup(
                                new MobileAppAdGroupAddMap()
                                        .defaultGroup()
                                        .withStoreUrl(mobileApp.getStoreHref())
                        )
        );
    }

    @After
    public void after() {
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).campaignsSteps()
                .unsetCampaignMobileAppId(campaignId);
    }

    @Test
    public void updateGroupAndCheckMobileAppIdOnCampaign() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withAdGroups(
                                new AdGroupUpdateItemMap().withId(adGroupId)
                                        .withMobileAppAdGroup(
                                                new MobileAppAdGroupUpdateMap()
                                                        .withTargetCarrier(TargetCarrierEnum.WI_FI_AND_CELLULAR)
                                                        .withTargetDeviceTypes(TargetDeviceTypeEnum.DEVICE_TYPE_MOBILE)
                                                        .withTargetOperatingSystemVersion(OSVersions.IOS_VERSIONS[9])
                                        )
                        ),
                ExpectedResult.success()
        );

        Long campaignMobileAppId = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).campaignsSteps()
                .getCampaignMobileAppId(campaignId);

        assertThat("Приложение на кампании не изменилось",
                campaignMobileAppId, equalTo(mobileApp.getMobileAppId()));
    }

    private MobileAppsRecord getAnyClientApp() {
        return api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT).mobileAppsSteps()
                .getMobileAppsByClient(clientId)
                .stream()
                .findFirst()
                .orElseThrow(() -> new AssertionError("Couldn't found any mobile app"));
    }
}
