package ru.yandex.autotests.direct.api.adgroups.update.mobileappadgroups;

import com.yandex.direct.api.v5.adgroups.TargetCarrierEnum;
import com.yandex.direct.api.v5.adgroups.TargetDeviceTypeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.OSVersions;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupUpdateMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Author buhter
 * Date 17.09.15
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Stories(AdGroupsStories.MOBILE)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
@Description("проверка SOAP")
public class MobileAppAdGroupUpdateSOAPTest {

    private static final String client = AdGroupsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).protocol(ProtocolType.SOAP).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Integer campaignId;
    private Long id;

    @BeforeClass
    public static void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign().intValue();
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        api.as(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .defaultAdGroupAddItem(campaignId.longValue())
                .withNegativeKeywords(AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD)
                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup())
        );
    }

    @Test
    public void successUpdateTest() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap()
                                .withId(id)
                                .withMobileAppAdGroup(new MobileAppAdGroupUpdateMap()
                                        .withTargetCarrier(TargetCarrierEnum.WI_FI_ONLY)
                                        .withTargetDeviceTypes(TargetDeviceTypeEnum.DEVICE_TYPE_MOBILE)
                                        .withTargetOperatingSystemVersion(OSVersions.ANDRIOD_VERSIONS[0])
                                )
                ),
                ExpectedResult.success()
        );
    }
}
