package ru.yandex.autotests.direct.api.adgroups.update.mobileappadgroups;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.MobileAppAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.TargetCarrierEnum;
import com.yandex.direct.api.v5.adgroups.TargetDeviceTypeEnum;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsStories;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.MobileContentStatusiconmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.AdgroupsMobileContentRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.MobileContentRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.bslogs.mobile.OSVersions;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupGetMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupUpdateMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExtensionModerationMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Author buhter
 * Date 17.09.15
 * https://st.yandex-team.ru/TESTIRT-7178
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Stories(AdGroupsStories.MOBILE)
@Issue("https://st.yandex-team.ru/DIRECT-44780")
public class MobileAppAdGroupUpdateSetOfFieldsTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AdGroupsLogins.CLIENT);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Integer campaignId;
    private Long id;
    private GetRequestMap getRequestMap;
    private MobileAppAdGroupGetMap expected;

    @BeforeClass
    public static void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign().intValue();
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addGroup(new AdGroupAddItemMap()
                .defaultAdGroupAddItem(campaignId.longValue())
                .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup())
        );
        getRequestMap = new GetRequestMap()
                .withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap()
                                .withIds(id)
                ).withFieldNames(AdGroupFieldEnum.ID)
                .withMobileAppAdGroupFieldNames(
                        MobileAppAdGroupFieldEnum.APP_ICON_MODERATION
                        , MobileAppAdGroupFieldEnum.STORE_URL
                        , MobileAppAdGroupFieldEnum.TARGET_CARRIER
                        , MobileAppAdGroupFieldEnum.TARGET_DEVICE_TYPE
                        , MobileAppAdGroupFieldEnum.TARGET_OPERATING_SYSTEM_VERSION
                );
        expected = new MobileAppAdGroupGetMap()
                .withStoreUrl(MobileAppAdGroupAddMap.DEFAULT_STORE_URL)
                .withTargetCarrier(MobileAppAdGroupAddMap.DEFAULT_TARGET_CARRIER)
                .withTargetOperatingSystemVersion(MobileAppAdGroupAddMap.DEFAULT_TARGET_OPERATING_SYSTEM_VERSION)
                .withTargetDeviceTypes(MobileAppAdGroupAddMap.DEFAULT_TARGET_DEVICE_TYPE)
                .withAppIconModeration(new ExtensionModerationMap()
                        .withStatus(StatusEnum.ACCEPTED)
                        .withStatusClarification("")
                );
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(AdGroupsLogins.CLIENT);
        AdgroupsMobileContentRecord adgroupsMobileContent = jooqDbSteps.adGroupsSteps().getAdGroupMobileContent(id);
        MobileContentRecord mobileContent = jooqDbSteps.mobileContentSteps().getMobileContent(adgroupsMobileContent.getMobileContentId());
        mobileContent.setIconHash("32453/dvwdsvwfwgwg");
        mobileContent.setStatusiconmoderate(MobileContentStatusiconmoderate.Yes);
        jooqDbSteps.mobileContentSteps().updateMobileContent(mobileContent);
    }

    @Test
    public void updateWithOnlyId() {
        //DIRECT-34193
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(id))
        );
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);

        assumeThat("вернулась одна группа", response.getAdGroups(), iterableWithSize(1));
        assertThat("вернулась правильная группа", response.getAdGroups().get(0).getMobileAppAdGroup(),
                beanDifferV5(expected.getBean()));
    }

    @Test
    public void updateOnlyTargetCarrier() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(id)
                        .withMobileAppAdGroup(new MobileAppAdGroupUpdateMap()
                                .withTargetCarrier(TargetCarrierEnum.WI_FI_ONLY)
                        )
                ));

        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        assumeThat("вернулась одна группа", response.getAdGroups(), iterableWithSize(1));
        assertThat("вернулась правильная группа", response.getAdGroups().get(0).getMobileAppAdGroup(),
                beanDifferV5(expected.withTargetCarrier(TargetCarrierEnum.WI_FI_ONLY).getBean()));
    }

    @Test
    public void updateOnlyTargetOperatingSystemVersion() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(id)
                        .withMobileAppAdGroup(new MobileAppAdGroupUpdateMap()
                                .withTargetOperatingSystemVersion(OSVersions.ANDRIOD_VERSIONS[0])
                        )
                ));
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        assumeThat("вернулась одна группа", response.getAdGroups(), iterableWithSize(1));
        assertThat("вернулась правильная группа", response.getAdGroups().get(0).getMobileAppAdGroup(),
                beanDifferV5(expected.withTargetOperatingSystemVersion(OSVersions.ANDRIOD_VERSIONS[0]).getBean()));
    }

    @Test
    public void updateOnlyTargetDeviceTypes() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(id)
                        .withMobileAppAdGroup(new MobileAppAdGroupUpdateMap()
                                .withTargetDeviceTypes(TargetDeviceTypeEnum.DEVICE_TYPE_MOBILE)
                        )
                ));
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        assumeThat("вернулась одна группа", response.getAdGroups(), iterableWithSize(1));
        assertThat("вернулась правильная группа", response.getAdGroups().get(0).getMobileAppAdGroup(),
                beanDifferV5(expected.withTargetDeviceTypes(TargetDeviceTypeEnum.DEVICE_TYPE_MOBILE).getBean()));
    }

    @Test
    public void updateAllFields() {
        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(id)
                        .withMobileAppAdGroup(new MobileAppAdGroupUpdateMap()
                                .withTargetCarrier(TargetCarrierEnum.WI_FI_ONLY)
                                .withTargetDeviceTypes(TargetDeviceTypeEnum.DEVICE_TYPE_MOBILE)
                                .withTargetOperatingSystemVersion(OSVersions.ANDRIOD_VERSIONS[0])
                        )
                ));
        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        assumeThat("вернулась одна группа", response.getAdGroups(), iterableWithSize(1));
        assertThat("вернулась правильная группа", response.getAdGroups().get(0).getMobileAppAdGroup(),
                beanDifferV5(expected.withTargetCarrier(TargetCarrierEnum.WI_FI_ONLY)
                        .withTargetDeviceTypes(TargetDeviceTypeEnum.DEVICE_TYPE_MOBILE)
                        .withTargetOperatingSystemVersion(OSVersions.ANDRIOD_VERSIONS[0]).getBean()));
    }
}
