package ru.yandex.autotests.direct.api.adgroups.update.mobileappadgroups;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.utils.model.RegionIDValues;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.GroupFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.ModerationFlag;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.MobileAppAdGroupAddMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 29.01.16.
 * https://st.yandex-team.ru/TESTIRT-8386
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-50356")
@Description("Проверка переотправки на модерацию по флагу forex")
@RunWith(Parameterized.class)
public class UpdateRegionOfMobileAppAdGroupWithForexFlagTest {
    private Long adGroupID;
    private Long adIDWithForex;
    private Long adID;
    private static final String LOGIN = AdGroupsLogins.CLIENT;

    public static final Long MOSCOW_REGION = RegionIDValues.MOSCOW_AND_MOSCOW_REGION.getId().longValue();
    public static final Long SPB = RegionIDValues.SPB.getId().longValue();
    public static final Long RUSSIA = RegionIDValues.RUSSIA_COUNTRY.getId().longValue();
    public static final Long EUROPE = RegionIDValues.EUROPE.getId().longValue();
    public static final Long UKRAINE = RegionIDValues.UKRAINE.getId().longValue();
    public static final Long TURKEY = RegionIDValues.TURKEY.getId().longValue();
    public static final Long SNG = RegionIDValues.SNG.getId().longValue();
    public static final Long ENGLAND = RegionIDValues.ENGLAND.getId().longValue();
    public static final Long CRIMEA = RegionIDValues.CRIMEA.getId().longValue();

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public Long[] addedRegionID;

    @Parameterized.Parameter(2)
    public Long[] updatedRegionID;

    @Parameterized.Parameter(3)
    public String expectedStatusModerate;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"обновляем регион с TURKEY на TURKEY, MOSCOW_REGION", new Long[]{TURKEY}, new Long[]{TURKEY, MOSCOW_REGION}, Status.READY},
                {"обновляем регион с SNG на SNG, SPB", new Long[]{SNG}, new Long[]{SNG, SPB}, Status.READY},
                {"обновляем регион с EUROPE на EUROPE", new Long[]{EUROPE}, new Long[]{RUSSIA}, Status.READY},
                {"обновляем регион с UKRAINE на ENGLAND", new Long[]{UKRAINE}, new Long[]{ENGLAND}, Status.YES},
                {"обновляем регион с ENGLAND на SPB", new Long[]{ENGLAND}, new Long[]{SPB}, Status.READY},
                {"обновляем регион с ENGLAND на CRIMEA", new Long[]{ENGLAND}, new Long[]{CRIMEA}, Status.YES},
                {"обновляем регион с ENGLAND на UKRAINE", new Long[]{ENGLAND}, new Long[]{UKRAINE}, Status.YES},
                {"обновляем регион с UKRAINE на UKRAINE, CRIMEA", new Long[]{UKRAINE}, new Long[]{UKRAINE, CRIMEA}, Status.YES},
                {"обновляем регион с SPB на ENGLAND", new Long[]{SPB}, new Long[]{ENGLAND}, Status.YES},
                {"обновляем регион с MOSCOW_REGION на MOSCOW_REGION, SPB", new Long[]{MOSCOW_REGION}, new Long[]{MOSCOW_REGION, SPB}, Status.YES},
        });
    }
    private static Long campaignID;

    @BeforeClass
    public static void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        campaignID = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createAdd() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);

        adGroupID = api.userSteps.adGroupsSteps().addGroup(
                new AdGroupAddItemMap()
                        .withCampaignId(campaignID)
                        .withName(AdGroupAddItemMap.DEFAULT_NAME)
                        .withRegionIds(addedRegionID)
                        .withMobileAppAdGroup(new MobileAppAdGroupAddMap().defaultGroup()));
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupID);

        adIDWithForex = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupID);
        adID = api.userSteps.adsSteps().addDefaultMobileAppAd(adGroupID);

        api.userSteps.campaignFakeSteps().makeCampaignModerated(campaignID.intValue());
        api.userSteps.groupFakeSteps().setStatusModerate(adGroupID, Status.YES);
        api.userSteps.groupFakeSteps().setStatusPostModerate(adGroupID, Status.YES);
        api.userSteps.bannersFakeSteps().makeBannersModerated(adIDWithForex);
        api.userSteps.bannersFakeSteps().makeBannersModerated(adID);

        api.userSteps.bannersFakeSteps().setBannerFlags(adIDWithForex, ModerationFlag.FOREX);

        api.userSteps.adGroupsSteps().adGroupsUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap().withId(adGroupID).withRegionIds(updatedRegionID)));
    }


    @Issue("DIRECT-50678")
    @Test
    public void checkStatusModerateOfAdWithFlagForex() {
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adIDWithForex);
        assertThat("у объявления верный статус модерации", bannerFakeInfo.getStatusModerate(), equalTo(expectedStatusModerate));
    }

    @Test
    public void checkStatusModerateOfAdWithoutFlagForex() {
        BannerFakeInfo bannerFakeInfo = api.userSteps.bannersFakeSteps().getBannerParams(adID);
        assertThat("объявление не отправилось на модерацию", bannerFakeInfo.getStatusModerate(), equalTo(Status.YES));
    }

    @Test
    public void checkStatusModerateOfAdGroup() {
        GroupFakeInfo groupFakeInfo = api.userSteps.groupFakeSteps().getGroupParams(adGroupID);
        assertThat("у группы верный статус модерации", groupFakeInfo.getStatusModerate(), equalTo(Status.YES));
    }
}

