package ru.yandex.autotests.direct.api.adgroups.update.negativekeywords;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.KeywordsSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/TESTIRT-10419")
@Description("Изменение минус-фразы в группе")
@RunWith(Parameterized.class)
public class UpdateNegativeKeyPhrasesPositiveTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String[] negativePhrases;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        String maxLengthNegativeWord = RandomStringUtils.randomAlphabetic(KeywordsSteps.MINUS_WORD_MAX_LENGTH);
        String maxWordInNegativePhrase = "белый медведь шьет себе шубу на зиму";

        ArrayList<String> maxLengthNegativePhrasesList = new ArrayList<>();
        maxLengthNegativePhrasesList.add(maxWordInNegativePhrase);
        int allPhrasesLength = maxWordInNegativePhrase.length();
        while (allPhrasesLength <= (KeywordsSteps.PHRASE_MAX_LENGTH - KeywordsSteps.MINUS_WORD_MAX_LENGTH)) {
            allPhrasesLength = allPhrasesLength + KeywordsSteps.MINUS_WORD_MAX_LENGTH;
            maxLengthNegativePhrasesList.add(RandomStringUtils.randomAlphabetic(KeywordsSteps.MINUS_WORD_MAX_LENGTH));
        }
        if (KeywordsSteps.PHRASE_MAX_LENGTH - allPhrasesLength > 0) {
            maxLengthNegativePhrasesList.add(
                    RandomStringUtils.randomAlphabetic(KeywordsSteps.MINUS_WORD_MAX_LENGTH)
                            .substring(0, KeywordsSteps.PHRASE_MAX_LENGTH - allPhrasesLength));
        }

        Object[][] data = new Object[][]{
                {"Min 2 words for negative key phrase", new String[]{"белый медведь"}},
                {"Max 7 words for negative key phrase", new String[]{maxWordInNegativePhrase}},
                {"35 symbol for word in negative key phrase", new String[]{maxLengthNegativeWord + " белый медведь"}},
                {"Max length 4096 symbol for negative key phrase", maxLengthNegativePhrasesList.toArray(
                        new String[maxLengthNegativePhrasesList.size()])},
                {"Phrase with a dash", new String[]{"онлайн-переводчик"}},
                {"+в горшках цветы", new String[]{"+в горшках цветы"}},
                {"цветы +в горшках", new String[]{"цветы +в горшках"}},
                {"цветы +в горшках, кот в мешке", new String[]{"цветы +в горшках", "кот в мешке"}},
                {"купить !цветы", new String[]{"купить !цветы"}},
                {"!купить !цветы", new String[]{"!купить !цветы"}},
                {"\"цветы в горшках\"", new String[]{"\"цветы в горшках\""}},
                {"\"купить цветы +в горшках недорого\"", new String[]{"\"купить цветы +в горшках недорого\""}},
                {"[из Москвы в Париж]", new String[]{"[из Москвы в Париж]"}},
                {"2 билета [из Москвы в Париж]", new String[]{"2 билета [из Москвы в Париж]"}},
                {"билеты [из Москвы в Париж]", new String[]{"билеты [из Москвы в Париж]"}},
                {"[из !Москвы в Париж]", new String[]{"[из !Москвы в Париж]"}},
                {" из !Москвы в Париж", new String[]{" из !Москвы в Париж"}},
                {"\"[из Москвы в Париж]\"", new String[]{"\"[из Москвы в Париж]\""}},
                {"говорить +по-английски", new String[]{"говорить +по-английски"}},
                {"[англо-русский переводчик]", new String[]{"[англо-русский переводчик]"}}
        };
        return Arrays.asList(data);
    }

    static Long campaignId;
    Long id;

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    public void updateGroupWithName() {
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap()
                                .withId(id)
                                .withNegativeKeywords(negativePhrases)
                ),
                ExpectedResult.success()
        );
    }
}
