package ru.yandex.autotests.direct.api.adgroups.update.negativekeywords;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.KeywordPhraseGenerator;
import ru.yandex.autotests.directapi.steps.banners.KeywordsSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


/**
 * Author pavryabov
 * Date 03.09.14
 * https://st.yandex-team.ru/TESTIRT-2022
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@RunWith(Parameterized.class)
public class UpdateNegativeKeywordsPositiveTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(AdGroupsLogins.CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String[] negativeKeywords;

    @Parameterized.Parameter(2)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        KeywordPhraseGenerator keywordPhraseGenerator =
                new KeywordPhraseGenerator(KeywordsSteps.CYRILLIC_CHARS_NO_SPACE);

        Object[][] data = new Object[][]{
                {"One russian keyword", new String[]{AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD},
                        ExpectedResult.success()},
                {"One english keyword", new String[]{"english"},
                        ExpectedResult.success()},
                {"Two negative keywords", new String[]{AdGroupAddItemMap.DEFAULT_NEGATIVE_KEYWORD, "кондиционеры"},
                        ExpectedResult.success()},
                {"One keyword with maximum length",
                        keywordPhraseGenerator
                                .generatePhraseWithPlusAndMinusWords(
                                        new Integer[0],
                                        new Integer[]{KeywordsSteps.MINUS_WORD_MAX_LENGTH})
                                .minusWordArray(),
                        ExpectedResult.success()},
                {"Two keywords with maximum length",
                        keywordPhraseGenerator
                                .generatePhraseWithPlusAndMinusWords(
                                        new Integer[0],
                                        new Integer[]{KeywordsSteps.MINUS_WORD_MAX_LENGTH, KeywordsSteps.MINUS_WORD_MAX_LENGTH})
                                .minusWordArray(),
                        ExpectedResult.success()},
                {"Many keywords with total length at exactly the limit",
                        keywordPhraseGenerator
                                .generatePhraseWithPlusAndMinusWords(
                                        new Integer[0],
                                        KeywordPhraseGenerator
                                                .minusWordLengthsWithSpecificTotalLength(
                                                        KeywordsSteps.MINUS_WORD_MAX_LENGTH,
                                                        KeywordsSteps.MINUS_WORD_MAX_LENGTH,
                                                        AdGroupAddItemMap.MAX_NEGATIVE_KEYWORDS_LENGTH
                                                )
                                                .toArray(new Integer[0]))
                                .minusWordArray(),
                        ExpectedResult.success()},
                {"+test", new String[]{"+test"},
                        ExpectedResult.success()},
                {"!test", new String[]{"!test"},
                        ExpectedResult.success()},
                {"te.st", new String[]{"te.st"},
                        ExpectedResult.success()},
                {"test.", new String[]{"test."},
                        ExpectedResult.success()},
                {"1test", new String[]{"1test"},
                        ExpectedResult.success()},
                {"te1st", new String[]{"te1st"},
                        ExpectedResult.success()},
                {"test1", new String[]{"test1"},
                        ExpectedResult.success()},
                {" test", new String[]{" test"},
                        ExpectedResult.success()},
                {"test ", new String[]{"test "},
                        ExpectedResult.success()}
        };
        return Arrays.asList(data);
    }

    static Long campaignId;
    Long id;

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(AdGroupsLogins.CLIENT);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(AdGroupsLogins.CLIENT);
        id = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1854")
    public void updateGroupWithName() {
        //DIRECT-34506
        //DIRECT-34529
        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(
                        new AdGroupUpdateItemMap()
                                .withId(id)
                                .withNegativeKeywords(negativeKeywords)
                ),
                expectedResult
        );
    }
}
