package ru.yandex.autotests.direct.api.adgroups.update.textadgroupfeedparams;

import java.util.Arrays;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.GetResponse;
import com.yandex.direct.api.v5.adgroups.TextAdGroupFeedParamsFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsFeatures;
import ru.yandex.autotests.direct.api.adgroups.AdGroupsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.AdGroupsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.TextAdGroupFeedParamsGetMap;
import ru.yandex.autotests.directapi.model.api5.adgroups.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExceptionNotificationMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.iterableWithSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pashkus on 25.09.21
 */
@Aqua.Test
@Features(AdGroupsFeatures.UPDATE)
@Issue("https://st.yandex-team.ru/DIRECT-147863")
public class TextAdGroupFeedParamsUpdateTest {

    public static final String LOGIN = AdGroupsLogins.CLIENT;
    private static final Integer FEEDS_NOT_ALLOWED = 10165;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long campaignId;
    static DirectJooqDbSteps dbSteps;
    private Long adGroupId;
    private GetRequestMap getRequestMap;
    private TextAdGroupFeedParamsGetMap expected;
    private static Long feedId;
    private static String clientId;

    @BeforeClass
    public static void initTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        int shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        clientId = api.userSteps.clientFakeSteps().getClientData(LOGIN).getClientID();
        feedId = dbSteps.feedsSteps().createDefaultFeed(clientId);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(LOGIN);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, LOGIN);
        getRequestMap = new GetRequestMap()
                .withSelectionCriteria(
                        new AdGroupsSelectionCriteriaMap()
                                .withIds(adGroupId)
                )
                .withFieldNames(AdGroupFieldEnum.ID)
                .withTextAdGroupFeedParamsFieldNames(
                        TextAdGroupFeedParamsFieldEnum.FEED_ID,
                        TextAdGroupFeedParamsFieldEnum.FEED_CATEGORY_IDS
                );
    }

    @Test
    public void updateWithOnlyFeedIdWithoutFeature() {
        setFeature(false);

        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withTextAdGroupFeedParams(feedId)
                ),
                ExpectedResult.warningsIgnoringDetailsAndMessage(
                        new ExceptionNotificationMap().withCode(FEEDS_NOT_ALLOWED))
        );

        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        expected = new TextAdGroupFeedParamsGetMap();

        assumeThat("вернулась одна группа", response.getAdGroups(), iterableWithSize(1));
        assertThat("вернулась правильная группа", response.getAdGroups().get(0).getTextAdGroupFeedParams(),
                beanDifferV5(expected.getBean()));
    }

    @Test
    public void updateWithFeedIdAndCategoriesWithFeature() {
        setFeature(true);

        api.userSteps.adGroupsSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withAdGroups(new AdGroupUpdateItemMap()
                        .withId(adGroupId)
                        .withTextAdGroupFeedParams(feedId, Arrays.asList(1L, 2L))
                ),
                ExpectedResult.warningsIgnoringDetailsAndMessage(
                        new ExceptionNotificationMap().withCode(FEEDS_NOT_ALLOWED))
        );

        GetResponse response = api.userSteps.adGroupsSteps().adGroupsGet(getRequestMap);
        expected = new TextAdGroupFeedParamsGetMap();

        assumeThat("вернулась одна группа", response.getAdGroups(), iterableWithSize(1));
        assertThat("вернулась правильная группа", response.getAdGroups().get(0).getTextAdGroupFeedParams(),
                beanDifferV5(expected.getBean()));
    }

    private void setFeature(Boolean isEnabled) {
        dbSteps.featuresSteps().setClientFeature(
                Long.valueOf(clientId),
                "allow_use_feeds_in_tgo_groups",
                isEnabled);
    }

}
