package ru.yandex.autotests.direct.api.adimages;

import java.util.Arrays;
import java.util.Collection;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import com.yandex.direct.api.v5.adimages.AdImageFieldEnum;
import com.yandex.direct.api.v5.adimages.AdImageGetItem;
import com.yandex.direct.api.v5.adimages.GetResponse;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesStepsV5;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Description("Чистим картинки пользователей")
@RunWith(Parameterized.class)
public class ClearAdImages {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter()
    public String login;

    @Parameterized.Parameters(name = "Login = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{{"at-no-image-client"}};
        return Arrays.asList(data);
    }

    @Test
    @TestCaseId("2811")
    public void clearUserAdImages() {
        ImagesStepsV5 imagesStepsV5 = api.as(login).userSteps.imagesStepsV5();

        GetResponse adimages = imagesStepsV5.adImagesGet(
                new ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap()
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                        .withSelectionCriteria(new AdImageSelectionCriteriaMap()));

        imagesStepsV5.adImagesDelete(
                adimages.getAdImages().stream().map(AdImageGetItem::getAdImageHash).limit(999).toArray(String[]::new));
    }

}
