package ru.yandex.autotests.direct.api.adimages.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Image;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageExpectedResult;
import ru.yandex.autotests.directapi.model.api5.adimages.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;


/**
 * Created by lightelfik on 10.05.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.ADD)
@Description("Проверка доступа на создание изображений для агентств")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
public class AdImagesAgencyTest {
    private static final String AGENCY = AdImagesLogins.AGENCY;
    private static final String CLIENT = AdImagesLogins.CLIENT_ADD;
    private static final String SUBCLIENT = AdImagesLogins.SUBCLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(AGENCY);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SUBCLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1877")
    public void checkSubclient() {
        Image image = ValidImageData.getValidRegularImage(5);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                SUBCLIENT,
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(image.getName())),
                AdImageExpectedResult.success()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1880")
    public void checkClient() {
        Image image = ValidImageData.getValidRegularImage(9);

        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                CLIENT,
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(image.getName())),
                new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)
        );
    }
}

