package ru.yandex.autotests.direct.api.adimages.add;

import com.yandex.direct.api.v5.adimages.AdImageFieldEnum;
import com.yandex.direct.api.v5.adimages.AddResponse;
import com.yandex.direct.api.v5.adimages.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Image;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by lightelfik on 31.05.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.ADD)
@Description("Проверка доступа на создание изображений для представителей клиентов")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
public class AdImagesClientRepTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_ADD;
    private static final String CLIENT_REP = AdImagesLogins.CLIENT_ADD_REP;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT_REP);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2118")
    public void checkRep() {

        Image image = ValidImageData.getValidRegularImage(8);

        AddResponse addResponse = api.as(CLIENT_REP).userSteps.imagesStepsV5().adImagesAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(image.getName()))
        );
        assumeThat("представитель добавил изображение", addResponse.getAddResults(), hasSize(1));

        String hash = addResponse.getAddResults().get(0).getAdImageHash();

        GetResponse getResponse = api.as(CLIENT).userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(hash)
                        )
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
        );
        assumeThat("клиент может получить изображение", getResponse.getAdImages(), hasSize(1));
    }
}

