package ru.yandex.autotests.direct.api.adimages.add;

import com.yandex.direct.api.v5.adimages.AddResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesPoolRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Image;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by lightelfik on 230.05.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Description("Проверка сохранения в базе изображений")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
@Features(AdImagesFeatures.ADD)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AdImagesDatabaseTest {

    private static final String CLIENT = AdImagesLogins.CLIENT_ADD;
    private static Long clientId;
    private static DirectJooqDbSteps dbSteps;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        clientId = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(CLIENT).getClientID());
        dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);
    }

    @Parameterized.Parameter(0)
    public String name;

    @Parameterized.Parameter(1)
    public Image image;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"картинка regular", ValidImageData.getValidRegularImage(3)},
                {"картинка wide", ValidImageData.getValidWideImage(2)},
                {"картинка image_ad", ValidImageData.getValidImageAdImage(4)},
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2120")
    public void checkDb() {
        AddResponse response = api.userSteps.imagesStepsV5().adImagesAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(image.getName()))
        );
        assumeThat("изображение добавлено", response.getAddResults(), hasSize(1));

        String hash = response.getAddResults().get(0).getAdImageHash();

        BannerImagesPoolRecord imageRecord =
                dbSteps.bannerImagesPoolSteps().getBannerImagesPool(clientId, hash);

        BannerImagesPoolRecord expectedImageRecord = new BannerImagesPoolRecord();
        expectedImageRecord.setClientid(clientId);
        expectedImageRecord.setName(image.getName());
        expectedImageRecord.setImageHash(hash);

        assertThat(
                "данные изображения были записаны в базу",
                imageRecord.intoMap(),
                beanDiffer(expectedImageRecord.intoMap()).useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields())
        );
    }

}
