package ru.yandex.autotests.direct.api.adimages.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Image;
import ru.yandex.autotests.directapi.model.InvalidImageData;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageExpectedResult;
import ru.yandex.autotests.directapi.model.api5.adimages.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;

/**
 * Created by lightelfik on 29.04.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.ADD)
@Description("Проверка валидации поля ImageData")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
@RunWith(Parameterized.class)
public class AdImagesImageDataValidationTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Parameterized.Parameter(0)
    public String name;

    @Parameterized.Parameter(1)
    public Image image;

    @Parameterized.Parameter(2)
    public AdImageExpectedResult result;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        List<Object[]> data = new ArrayList();
        Image imageForParameter = InvalidImageData.getInvalidBigImage(6);
        data.add(new Object[]{
                imageForParameter.getName(),
                imageForParameter,
                AdImageExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.IMAGE_FORMAT_INVALID))
        });

//        imageForParameter = InvalidImageData.getInvalidBigImage(7);
//        data.add(new Object[]{
//                imageForParameter.getName(),
//                imageForParameter,
//                AdImageExpectedResult.errors(
//                        new Notification(5010, Api5ErrorDetails.IMAGE_FILE_SIZE_INVALID))
//        }); //only for local run

//        imageForParameter = InvalidImageData.getInvalidBigImage(8);
//        data.add(new Object[]{
//                imageForParameter.getName(),
//                imageForParameter,
//                AdImageExpectedResult.errors(
//                        new Notification(5010, Api5ErrorDetails.IMAGE_FILE_SIZE_INVALID))
//        }); //only for local run

//        imageForParameter = InvalidImageData.getInvalidBigImage(9);
//        data.add(new Object[]{
//                imageForParameter.getName(),
//                imageForParameter,
//                AdImageExpectedResult.errors(
//                        new Notification(5010,
//                                Api5ErrorDetails.IMAGE_FILE_SIZE_INVALID_IMAGEAD,
//                                imageForParameter.getDimensions()))
//        }); //only for local run

        imageForParameter = InvalidImageData.getInvalidSmallImage(6);
        data.add(new Object[]{
                imageForParameter.getName(),
                imageForParameter,
                AdImageExpectedResult.errors(
                        new Notification(5004, Api5ErrorDetails.IMAGE_FORMAT_INVALID))
        });
        for (int i : IntStream.range(1, 4).toArray()) {
            imageForParameter = InvalidImageData.getInvalidBigImage(i);
            data.add(new Object[]{
                    imageForParameter.getName(),
                    imageForParameter,
                    AdImageExpectedResult.errors(
                            new Notification(5004, Api5ErrorDetails.IMAGE_SIZE_INVALID))
            });
        }
        for (int i : IntStream.range(1, 5).toArray()) {
            imageForParameter = InvalidImageData.getInvalidSmallImage(i);
            data.add(new Object[]{
                    imageForParameter.getName(),
                    imageForParameter,
                    AdImageExpectedResult.errors(
                            new Notification(5004, Api5ErrorDetails.IMAGE_SIZE_INVALID))
            });
        }
        for (int i : IntStream.range(7, 11).toArray()) {
            imageForParameter = InvalidImageData.getInvalidSmallImage(i);
            data.add(new Object[]{
                    imageForParameter.getName(),
                    imageForParameter,
                    AdImageExpectedResult.errors(
                            new Notification(5004, Api5ErrorDetails.IMAGE_SIZE_INVALID))
            });
        }
        for (int i : IntStream.range(1, 13).toArray()) {
            imageForParameter = ValidImageData.getValidRegularImage(i);
            data.add(new Object[]{
                    imageForParameter.getName(),
                    imageForParameter,
                    AdImageExpectedResult.success()
            });
        }
        for (int i : IntStream.range(1, 4).toArray()) {
            imageForParameter = ValidImageData.getValidWideImage(i);
            data.add(new Object[]{
                    imageForParameter.getName(),
                    imageForParameter,
                    AdImageExpectedResult.success()
            });
        }

        return data;
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2121")
    public void checkFile() {
        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(image.getName())),
                result
        );
    }
}


