package ru.yandex.autotests.direct.api.adimages.add;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageExpectedResult;
import ru.yandex.autotests.directapi.model.api5.adimages.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;

/**
 * Created by lightelfik on 18.05.16.
 * https://st.yandex-team.ru/TESTIRT-8445
 */
@Aqua.Test
@Features(AdImagesFeatures.ADD)
@Description("Проверка лимита массива AdImages")
@Issue("https://st.yandex-team.ru/DIRECT-50157")
public class AdImagesLimitTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_ADD_1;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2292")
    public void withMoreThanMaxAdImagesInRequest() {
        AdImageAddItemMap[] adImages = new AdImageAddItemMap[AddRequestMap.MAX_AMOUNT_OF_IMAGE_IN_ADD_REQUEST + 1];
        Arrays.fill(adImages, new AdImageAddItemMap()
                .withImageData(new byte[]{1})
                .withName("name")
        );

        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                new AddRequestMap().withAdImages(adImages),
                new Api5Error(9300,
                        Api5ErrorDetails.IMAGE_ADD_LIMIT_EXCEEDED,
                        AddRequestMap.MAX_AMOUNT_OF_IMAGE_IN_ADD_REQUEST
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2293")
    public void withMaxAdImagesInRequest() {
        AdImageAddItemMap[] adImages = new AdImageAddItemMap[AddRequestMap.MAX_AMOUNT_OF_IMAGE_IN_ADD_REQUEST];
        Arrays.fill(adImages, new AdImageAddItemMap()
                .withImageData(new byte[]{1})
                .withName("name")
        );
        AdImageExpectedResult[] result = new AdImageExpectedResult[AddRequestMap.MAX_AMOUNT_OF_IMAGE_IN_ADD_REQUEST];
        Arrays.fill(result, AdImageExpectedResult.errors(new Notification(5004, Api5ErrorDetails.IMAGE_FORMAT_INVALID)));

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(adImages),
                result
        );
    }
}
