package ru.yandex.autotests.direct.api.adimages.add;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Image;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageExpectedResult;
import ru.yandex.autotests.directapi.model.api5.adimages.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;
import java.util.Collection;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by lightelfik on 29.04.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.ADD)
@Description("Проверка валидации поля Name")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
@RunWith(Parameterized.class)
public class AdImagesNameValidationTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Parameterized.Parameter(0)
    public String name;

    @Parameterized.Parameter(1)
    public AdImageExpectedResult result;

    @Parameterized.Parameters(name = "name = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {RandomStringUtils.randomAlphabetic(AddRequestMap.MAX_NAME_LENGTH + 1),
                        AdImageExpectedResult.errors(
                                new Notification(5001,
                                        Api5ErrorDetails.FIELD_VALUE_SHOULD_NOT_BE_MORE_THAN,
                                        capitalize(AdImageAddItemMap.NAME),
                                        AddRequestMap.MAX_NAME_LENGTH
                                )
                        )},
                {"",
                        AdImageExpectedResult.errors(
                                new Notification(4000,
                                        Api5ErrorDetails.STRING_FIELD_SHOULD_NOT_BE_EMPTY,
                                        capitalize(AdImageAddItemMap.NAME)
                                )
                        )},
                {"        ",
                        AdImageExpectedResult.errors(
                                new Notification(4000,
                                        Api5ErrorDetails.STRING_FIELD_SHOULD_NOT_BE_EMPTY,
                                        capitalize(AdImageAddItemMap.NAME)
                                )
                        )},
                {RandomStringUtils.randomAlphabetic(AddRequestMap.MAX_NAME_LENGTH),
                        AdImageExpectedResult.success()},
                {"имя,.?!name #$@*(01%)",
                        AdImageExpectedResult.success()},
        };
        return Arrays.asList(data);
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2294")
    public void checkName() {
        Image image = ValidImageData.getValidRegularImage(10);
        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(name)),
                result
        );
    }
}



