package ru.yandex.autotests.direct.api.adimages.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.utils.ImageBase64Utils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import static org.apache.commons.lang3.StringUtils.capitalize;


/**
 * Created by lightelfik on 6.05.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.ADD)
@Description("Проверка валидации обязательности полей")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
public class AdImagesRequiredFieldsTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2297")
    public void CheckAdImageWithoutName() {
        String url = ValidImageData.getValidRegularImage(9).getUrl();

        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap().withImageData(url)),
                new Api5Error(8000, Api5ErrorDetails.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.AD_IMAGES), capitalize(AdImageAddItemMap.NAME))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2298")
    public void CheckAdImageWithNullName() {
        String url = ValidImageData.getValidRegularImage(9).getUrl();
        byte[] image = ImageBase64Utils.getFileData(url);

        JsonObject adImage = new JsonObject()
                .with(capitalize(AdImageAddItemMap.IMAGE_DATA), image)
                .with(capitalize(AdImageAddItemMap.NAME), "null");
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.AD_IMAGES), new Object[]{adImage});
        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE, capitalize(AdImageAddItemMap.NAME))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2295")
    public void CheckAdImageWithoutImageData() {
        String name = ValidImageData.getValidRegularImage(9).getName();

        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap().withName(name)),
                new Api5Error(8000, Api5ErrorDetails.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.AD_IMAGES), capitalize(AdImageAddItemMap.IMAGE_DATA))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2296")
    public void CheckAdImageWithNullImageData() {
        String name = ValidImageData.getValidRegularImage(9).getName();

        JsonObject adImage = new JsonObject()
                .with(capitalize(AdImageAddItemMap.IMAGE_DATA), "null")
                .with(capitalize(AdImageAddItemMap.NAME), name);
        JsonObject request = new JsonObject().with(capitalize(AddRequestMap.AD_IMAGES), new Object[]{adImage});
        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE, capitalize(AdImageAddItemMap.IMAGE_DATA))
        );
    }
}


