package ru.yandex.autotests.direct.api.adimages.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Image;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageExpectedResult;
import ru.yandex.autotests.directapi.model.api5.adimages.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by lightelfik on 30.05.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.ADD)
@Description("Проверка работоспособности метода AdImages.add по SOAP протоколу")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
public class AdImagesSOAPTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_ADD;
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT).protocol(ProtocolType.SOAP);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String PARAMS = "params";

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2300")
    public void addOneValidAdImage() {

        Image image = ValidImageData.getValidRegularImage(8);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(image.getName())),
                AdImageExpectedResult.success()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2299")
    public void emptyRequest() {
        api.userSteps.imagesStepsV5().expectErrorOnAdd(new AddRequestMap(),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD, "AddRequest",
                        capitalize(AddRequestMap.AD_IMAGES)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2301")
    public void emptyArrayOfAdImages() {
        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                new AddRequestMap().withAdImages(),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD, "AddRequest",
                        capitalize(AddRequestMap.AD_IMAGES)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2302")
    public void nullInsteadOfAdImageItem() {
        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                new AddRequestMap().withAdImages(new AdImageAddItemMap(null)),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD, "AddRequest",
                        capitalize(AddRequestMap.AD_IMAGES)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2303")
    public void сheckAdImageWithoutName() {
        String url = ValidImageData.getValidRegularImage(9).getUrl();

        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap().withImageData(url)),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.AD_IMAGES), capitalize(AdImageAddItemMap.NAME))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2304")
    public void сheckAdImageWithoutImageData() {
        String name = ValidImageData.getValidRegularImage(9).getName();

        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap().withName(name)),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.AD_IMAGES), capitalize(AdImageAddItemMap.IMAGE_DATA))
        );
    }

}

