package ru.yandex.autotests.direct.api.adimages.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesFormatsImageType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannerImagesFormatsNamespace;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesFormatsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Image;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.beandiffer2.comparestrategy.defaultcomparestrategy.DefaultCompareStrategies;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.Arrays;
import java.util.Collection;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 28.06.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.ADD)
@Description("Проверка правильной записи в ppc.banner_images_formats")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
@RunWith(Parameterized.class)
public class AdImagesSaveToBannerImagesFormatsTest {

    private static final String CLIENT = AdImagesLogins.CLIENT_ADD;

    private static DirectJooqDbSteps dbSteps;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);
    }

    @Parameterized.Parameter(0)
    public String name;

    @Parameterized.Parameter(1)
    public Image image;

    @Parameterized.Parameter(2)
    public BannerImagesFormatsImageType imageType;

    @Parameterized.Parameter(3)
    public BannerImagesFormatsNamespace namespace;

    @Parameterized.Parameter(4)
    public Integer width;

    @Parameterized.Parameter(5)
    public Integer height;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"картинка regular", ValidImageData.getValidRegularImage(1), BannerImagesFormatsImageType.regular,
                        BannerImagesFormatsNamespace.direct, 450, 600},
                {"картинка wide", ValidImageData.getValidWideImage(1), BannerImagesFormatsImageType.wide,
                        BannerImagesFormatsNamespace.direct, 1080, 607},
                {"картинка image_ad", ValidImageData.getValidImageAdImage(3), BannerImagesFormatsImageType.image_ad,
                        BannerImagesFormatsNamespace.direct_picture, 728, 90},
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2305")
    public void checkBannerImagesFormats() {
        String adImagesHash = api.userSteps.imagesStepsV5().adImagesAdd(
                new AdImageAddItemMap()
                        .withImageData(image.getUrl())
                        .withName(image.getName())).get(0);
        BannerImagesFormatsRecord bannerImagesFormats =
                dbSteps.imagesSteps().getBannerImagesFormatsRecords(adImagesHash);
        BannerImagesFormatsRecord expectedBannerImagesFormats = new BannerImagesFormatsRecord();
        expectedBannerImagesFormats.setImageHash(adImagesHash);
        expectedBannerImagesFormats.setImageType(imageType);
        expectedBannerImagesFormats.setWidth(width.shortValue());
        expectedBannerImagesFormats.setHeight(height.shortValue());
        assertThat("картинка правильно сохранилась в ppc.banner_images_formats", bannerImagesFormats.intoMap(),
                beanDiffer(expectedBannerImagesFormats.intoMap())
                        .useCompareStrategy(DefaultCompareStrategies.onlyExpectedFields()));
    }
}
