package ru.yandex.autotests.direct.api.adimages.add;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Image;
import ru.yandex.autotests.directapi.model.InvalidImageData;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageExpectedResult;
import ru.yandex.autotests.directapi.model.api5.adimages.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by lightelfik on 26.04.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.ADD)
@Description("Проверка правильности списания баллов")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
public class AdImagesUnitsTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_ADD_UNITS;
    private static final int CALL_COST = 20;
    private static final int AD_IMAGE_COST = 20;
    private static final int DEFAULT_ERROR_COST = 20;
    private static final int COMMON_REQUEST_ERROR = 50;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    @Step("Обнуляем потраченные клиентом баллы")
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2311")
    public void oneAdImage() {
        Image image = ValidImageData.getValidRegularImage(2);

        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl()).withName(image.getName())
                ),
                AdImageExpectedResult.success()
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + AD_IMAGE_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2312")
    public void twoAdImages() {
        Image regularImage = ValidImageData.getValidRegularImage(4);
        Image wideImage = ValidImageData.getValidWideImage(3);

        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(regularImage.getUrl())
                                .withName(regularImage.getName()),
                        new AdImageAddItemMap()
                                .withImageData(wideImage.getUrl())
                                .withName(wideImage.getName())),
                AdImageExpectedResult.success(),
                AdImageExpectedResult.success()
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + (2 * AD_IMAGE_COST)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2307")
    public void oneAdImageWithError() {
        Image image = InvalidImageData.getInvalidBigImage(1);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(image.getName())
                ),
                AdImageExpectedResult.errors(new Notification(5004, Api5ErrorDetails.IMAGE_SIZE_INVALID))
        );

        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + DEFAULT_ERROR_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2308")
    public void twoAdImagesWithOneError() {
        Image regularImage = ValidImageData.getValidRegularImage(4);
        Image smallImage = InvalidImageData.getInvalidSmallImage(3);

        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(regularImage.getUrl())
                                .withName(regularImage.getName()),
                        new AdImageAddItemMap()
                                .withImageData(smallImage.getUrl())
                                .withName(smallImage.getName())
                ),
                AdImageExpectedResult.success(),
                AdImageExpectedResult.errors(new Notification(5004, Api5ErrorDetails.IMAGE_SIZE_INVALID))
        );

        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + AD_IMAGE_COST + DEFAULT_ERROR_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2309")
    public void twoAdImagesWithTwoError() {
        Image bigImage = InvalidImageData.getInvalidBigImage(2);
        Image smallImage = InvalidImageData.getInvalidSmallImage(3);

        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(bigImage.getUrl())
                                .withName(bigImage.getName()),
                        new AdImageAddItemMap()
                                .withImageData(smallImage.getUrl())
                                .withName(smallImage.getName())
                ),
                AdImageExpectedResult.errors(new Notification(5004, Api5ErrorDetails.IMAGE_SIZE_INVALID)),
                AdImageExpectedResult.errors(new Notification(5004, Api5ErrorDetails.IMAGE_SIZE_INVALID))
        );

        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + 2 * DEFAULT_ERROR_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2310")
    public void adImageWithCommonError() {

        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);

        api.userSteps.imagesStepsV5().expectErrorOnAdd(new AddRequestMap(),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD, "params",
                        capitalize(AddRequestMap.AD_IMAGES)));


        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(COMMON_REQUEST_ERROR));
    }

}

