package ru.yandex.autotests.direct.api.adimages.add;

import com.yandex.direct.api.v5.adimages.AdImageFieldEnum;
import com.yandex.direct.api.v5.adimages.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Image;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.*;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.List;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.contains;
import static org.hamcrest.Matchers.equalTo;

/**
 * Created by lightelfik on 29.04.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.ADD)
@Description("Проверка работоспособности в случае добавления одинаковых картинок или картинок с одинаковыми названиями")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
public class AdImagesWithSameFieldsTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2313")
    public void sameImagesWithDifferentName() {
        String otherName = ValidImageData.getValidRegularImage(4).getName();
        Image image = ValidImageData.getValidRegularImage(3);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(image.getName()),
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(otherName)),
                AdImageExpectedResult.success(), AdImageExpectedResult.success()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2314")
    public void saveLastName() {
        String otherName = ValidImageData.getValidRegularImage(4).getName();
        Image image = ValidImageData.getValidRegularImage(5);

        List<String> hashes = api.userSteps.imagesStepsV5().adImagesAdd(
                new AdImageAddItemMap()
                        .withImageData(image.getUrl())
                        .withName(image.getName()),
                new AdImageAddItemMap()
                        .withImageData(image.getUrl())
                        .withName(otherName)
        );
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(hashes.get(0))
                        )
                        .withFieldNames(AdImageFieldEnum.NAME)
        );

        assertThat("вернулось имя картинки загруженной последней",
                response.getAdImages().get(0).getName(), equalTo(otherName));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2315")
    public void sameImagesWithSameName() {
        Image image = ValidImageData.getValidRegularImage(7);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(image.getName()),
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(image.getName())),
                AdImageExpectedResult.success(), AdImageExpectedResult.success()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2317")
    public void sameImagesWithSameNameTwoRequests() {
        Image image = ValidImageData.getValidRegularImage(6);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(image.getName())),
                AdImageExpectedResult.success()
        );

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(image.getName())),
                AdImageExpectedResult.success()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2316")
    public void sameImagesHasSameHashes() {
        Image image = ValidImageData.getValidRegularImage(3);

        List<String> hashes = api.userSteps.imagesStepsV5().adImagesAdd(
                new AdImageAddItemMap()
                        .withImageData(image.getUrl())
                        .withName(image.getName()),
                new AdImageAddItemMap()
                        .withImageData(image.getUrl())
                        .withName(image.getName())
        );
        assertThat("хеши совпадают", hashes, contains(hashes.get(0), hashes.get(0)));
    }
}


