package ru.yandex.autotests.direct.api.adimages.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Image;
import ru.yandex.autotests.directapi.model.InvalidImageData;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageExpectedResult;
import ru.yandex.autotests.directapi.model.api5.adimages.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;


/**
 * Created by lightelfik on 29.04.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.ADD)
@Description("Проверка работоспособности в случае добавления нескольких картинок, как валидных так и нет")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
@Tag(TagDictionary.TRUNK)
public class AdImagesWithSomeImagesTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2318")
    public void twoImagesFirstInvalid() {
        Image validImage = ValidImageData.getValidRegularImage(4);
        Image invalidImage = InvalidImageData.getInvalidSmallImage(3);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(invalidImage.getUrl())
                                .withName(invalidImage.getName()),
                        new AdImageAddItemMap()
                                .withImageData(validImage.getUrl())
                                .withName(validImage.getName())),
                AdImageExpectedResult.errors(new Notification(5004, Api5ErrorDetails.IMAGE_SIZE_INVALID)), AdImageExpectedResult.success()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2319")
    public void twoImagesSecondInvalid() {
        Image validImage = ValidImageData.getValidRegularImage(4);
        Image invalidImage = InvalidImageData.getInvalidSmallImage(3);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(validImage.getUrl())
                                .withName(validImage.getName()),
                        new AdImageAddItemMap()
                                .withImageData(invalidImage.getUrl())
                                .withName(invalidImage.getName())),
                AdImageExpectedResult.success(), AdImageExpectedResult.errors(new Notification(5004, Api5ErrorDetails.IMAGE_SIZE_INVALID))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2320")
    public void twoImagesBothInvalid() {
        Image bigImage = InvalidImageData.getInvalidBigImage(1);
        Image smallImage = InvalidImageData.getInvalidSmallImage(2);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(bigImage.getUrl())
                                .withName(bigImage.getName()),
                        new AdImageAddItemMap()
                                .withImageData(smallImage.getUrl())
                                .withName(smallImage.getName())),
                AdImageExpectedResult.errors(new Notification(5004, Api5ErrorDetails.IMAGE_SIZE_INVALID)), AdImageExpectedResult.errors(new Notification(5004, Api5ErrorDetails.IMAGE_SIZE_INVALID))
        );
    }
}
