package ru.yandex.autotests.direct.api.adimages.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Image;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageExpectedResult;
import ru.yandex.autotests.directapi.model.api5.adimages.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;


/**
 * Created by lightelfik on 29.04.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.ADD)
@Description("Проверка работоспособности в случае добавления валидных картинок разных типов")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
@Tag(TagDictionary.TRUNK)
public class AdImagesWithValidTypeTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2321")
    public void oneValidRegularImage() {
        Image image = ValidImageData.getValidRegularImage(3);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(image.getName())),
                AdImageExpectedResult.success()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2322")
    public void oneValidWideImage() {
        Image image = ValidImageData.getValidWideImage(1);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(image.getName())),
                AdImageExpectedResult.success()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2323")
    public void oneValidImageAdImage() {
        Image image = ValidImageData.getValidImageAdImage(1);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(image.getUrl())
                                .withName(image.getName())
                ),
                AdImageExpectedResult.success()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2324")
    public void threeDifferentValidImages() {
        Image regularImage = ValidImageData.getValidRegularImage(4);
        Image wideImage = ValidImageData.getValidWideImage(3);
        Image imageAdImage = ValidImageData.getValidImageAdImage(2);

        api.userSteps.imagesStepsV5().shouldGetResultOnAdd(
                new AddRequestMap().withAdImages(
                        new AdImageAddItemMap()
                                .withImageData(regularImage.getUrl())
                                .withName(regularImage.getName()),
                        new AdImageAddItemMap()
                                .withImageData(wideImage.getUrl())
                                .withName(wideImage.getName()),
                        new AdImageAddItemMap()
                                .withImageData(imageAdImage.getUrl())
                                .withName(imageAdImage.getName())),
                AdImageExpectedResult.success(), AdImageExpectedResult.success(), AdImageExpectedResult.success()
        );
    }


}


