package ru.yandex.autotests.direct.api.adimages.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import static org.apache.commons.lang3.StringUtils.capitalize;


/**
 * Created by lightelfik on 29.04.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.ADD)
@Description("Проверка работоспособности в случае ошибки в запросе")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
public class AdImagesWrongRequest {
    private static final String CLIENT = AdImagesLogins.CLIENT_ADD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String PARAMS = "params";

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2325")
    public void emptyRequest() {
        api.userSteps.imagesStepsV5().expectErrorOnAdd(new AddRequestMap(),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD, PARAMS,
                        capitalize(AddRequestMap.AD_IMAGES)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2326")
    public void emptyArrayOfAdImages() {
        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                new AddRequestMap().withAdImages(),
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        capitalize(AddRequestMap.AD_IMAGES)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2327")
    public void nullInsteadOfAdImageItem() {
        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                new AddRequestMap().withAdImages(new AdImageAddItemMap(null)),
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_CANT_HAVE_NULL_VALUE,
                        capitalize(AddRequestMap.AD_IMAGES)));
    }
}
