package ru.yandex.autotests.direct.api.adimages.add;

import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AddRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.utils.ImageBase64Utils;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by lightelfik on 29.04.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.ADD)
@Description("Проверка работоспособности в случае неправильного формата запроса")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
public class AdImagesWrongRequestFormat {
    private static final String CLIENT = AdImagesLogins.CLIENT_ADD;
    private static byte[] image;
    private static String name;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String PARAMS = "params";

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        String url = ValidImageData.getValidRegularImage(1).getUrl();
        name = ValidImageData.getValidRegularImage(1).getName();
        image = ImageBase64Utils.getFileData(url);
    }

    @Test
    public void invalidFieldInParams() {

        JSONObject request = new JSONObject();
        JSONObject adImage = new JSONObject();
        adImage.put(capitalize(AdImageAddItemMap.IMAGE_DATA), image);
        adImage.put(capitalize(AdImageAddItemMap.NAME), name);
        request.put(AddRequestMap.AD_IMAGES, new Object[]{adImage});
        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_CONTAIN_UNKNOWN_FIELD, PARAMS, AddRequestMap.AD_IMAGES)
        );
    }

    @Test
    public void arrayInParams() {
        JSONObject request = new JSONObject();
        JSONObject adImage = new JSONObject();
        adImage.put(capitalize(AdImageAddItemMap.IMAGE_DATA), image);
        adImage.put(capitalize(AdImageAddItemMap.NAME), name);
        request.put(capitalize(AddRequestMap.AD_IMAGES), new Object[]{adImage});
        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                new Object[]{request},
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY, PARAMS)
        );
    }

    @Test
    public void notArrayInAdImages() {
        JSONObject request = new JSONObject();
        JSONObject adImage = new JSONObject();
        adImage.put(capitalize(AdImageAddItemMap.IMAGE_DATA), image);
        adImage.put(capitalize(AdImageAddItemMap.NAME), name);
        request.put(capitalize(AddRequestMap.AD_IMAGES), adImage);
        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(AddRequestMap.AD_IMAGES))
        );
    }

    @Test
    public void arrayInElementOfAdImages() {
        JSONObject request = new JSONObject();
        JSONObject adImage = new JSONObject();
        adImage.put(capitalize(AdImageAddItemMap.IMAGE_DATA), image);
        adImage.put(capitalize(AdImageAddItemMap.NAME), name);
        request.put(capitalize(AddRequestMap.AD_IMAGES), new Object[]{new Object[]{adImage}});
        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_MUST_CONTAIN_OBJECT,
                        capitalize(AddRequestMap.AD_IMAGES))
        );
    }

    @Test
    public void invalidFieldInAdImages() {
        JSONObject request = new JSONObject();
        JSONObject adImage = new JSONObject();
        adImage.put(AdImageAddItemMap.IMAGE_DATA, image);
        adImage.put(capitalize(AdImageAddItemMap.NAME), name);
        request.put(capitalize(AddRequestMap.AD_IMAGES), new Object[]{adImage});
        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
                        capitalize(AddRequestMap.AD_IMAGES), AdImageAddItemMap.IMAGE_DATA)
        );
    }

    @Test
    public void arrayInName() {
        String url = ValidImageData.getValidRegularImage(9).getUrl();
        byte[] image = ImageBase64Utils.getFileData(url);

        JSONObject request = new JSONObject();
        JSONObject adImage = new JSONObject();
        adImage.put(capitalize(AdImageAddItemMap.IMAGE_DATA), image);
        adImage.put(capitalize(AdImageAddItemMap.NAME), new String[0]);
        request.put(capitalize(AddRequestMap.AD_IMAGES), new Object[]{adImage});

        api.userSteps.imagesStepsV5().expectErrorOnAdd(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY, capitalize(AdImageAddItemMap.NAME))
        );
    }
}


