package ru.yandex.autotests.direct.api.adimages.delete;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageExpectedResult;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageHashesCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/**
 * Created by lightelfik on 11.05.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.DELETE)
@Description("Проверка валидации элементов поля AdImageHashes")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
@RunWith(Parameterized.class)
public class AdImageHashesItemValidationTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_DELETE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Parameterized.Parameter(0)
    public Object hash;

    @Parameterized.Parameter(1)
    public AdImageExpectedResult expectedResult;


    @Parameterized.Parameters(name = "hash = {0}")
    public static Collection testData() {
        //разрешенные символы A-Z, a-z, 0-9, -, _
        List<String> clientHashes = api.as(CLIENT).userSteps.imagesStepsV5().adImagesAdd(
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidRegularImage(6).getUrl())
                        .withName(ValidImageData.getValidRegularImage(6).getName()),
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidWideImage(1).getUrl())
                        .withName(ValidImageData.getValidWideImage(1).getName()),
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidImageAdImage(1).getUrl())
                        .withName(ValidImageData.getValidImageAdImage(1).getName())
        );

        Object[][] data = new Object[][]{
                {"", AdImageExpectedResult.errors(
                        new Notification(4000, Api5ErrorDetails.IMAGE_HASH_CANNOT_BE_EMPTY)
                )},
                {RandomStringUtils.randomAlphabetic(23), AdImageExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)
                )},
                {"     ", AdImageExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)
                )},
                {5, AdImageExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)
                )},
                {StringUtils.repeat("ц", 22), AdImageExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)
                )},
                {StringUtils.substring(clientHashes.get(0), 0, 21).concat(","), AdImageExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)
                )},
                {"!".concat(StringUtils.substring(clientHashes.get(0), 1, 22)), AdImageExpectedResult.errors(
                        new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND)
                )},
                {clientHashes.get(0), AdImageExpectedResult.success()},
                {clientHashes.get(1), AdImageExpectedResult.success()},
                {clientHashes.get(2), AdImageExpectedResult.success()},
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2328")
    public void nullInAdImageHashesItem() {
        //DIRECT-55565
        api.userSteps.imagesStepsV5().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap().withAdImageHashes(hash)
                ),
                expectedResult
        );
    }
}


