package ru.yandex.autotests.direct.api.adimages.delete;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageExpectedResult;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageHashesCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.List;

/**
 * Created by lightelfik on 10.05.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.DELETE)
@Description("Проверка доступа на удаление изображений для агенств")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
public class AdImagesAgencyTest {
    private static final String AGENCY = AdImagesLogins.AGENCY;
    private static final String CLIENT = AdImagesLogins.CLIENT_DELETE;
    private static final String SUBCLIENT = AdImagesLogins.SUBCLIENT;
    private static List<String> clientHashes;
    private static List<String> subclientHashes;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SUBCLIENT);
        clientHashes = api.as(CLIENT).userSteps.imagesStepsV5().adImagesAdd(
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidRegularImage(2).getUrl())
                        .withName(ValidImageData.getValidRegularImage(2).getName()),
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidRegularImage(3).getUrl())
                        .withName(ValidImageData.getValidRegularImage(3).getName())
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2329")
    public void checkRightsToSubclient() {
        subclientHashes = api.as(AGENCY).userSteps.imagesStepsV5().adImagesAdd(
                SUBCLIENT,
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidRegularImage(1).getUrl())
                        .withName(ValidImageData.getValidRegularImage(1).getName())
        );
        api.as(AGENCY).userSteps.imagesStepsV5().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap()
                                .withAdImageHashes(subclientHashes.get(0))
                ),
                SUBCLIENT,
                AdImageExpectedResult.success()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2331")
    public void checkRightsToSubclientNotOwnedImage() {
        api.as(AGENCY).userSteps.imagesStepsV5().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap()
                                .withAdImageHashes(clientHashes.get(0))
                ),
                SUBCLIENT,
                AdImageExpectedResult.errors(new Notification(8800, Api5ErrorDetails.IMAGE_NOT_FOUND))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2330")
    public void checkRightsToClient() {
        api.as(AGENCY).userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap()
                                .withAdImageHashes(clientHashes.get(1))
                ),
                CLIENT,
                new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN)

        );
    }


}

