package ru.yandex.autotests.direct.api.adimages.delete;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageExpectedResult;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageHashesCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.List;

/**
 * Created by lightelfik on 31.05.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.DELETE)
@Description("Проверка доступа на удаление изображений для представителей клиентов")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
public class AdImagesClientRepTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_DELETE;
    private static final String CLIENT_REP = AdImagesLogins.CLIENT_DELETE_REP;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT_REP);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2340")
    public void checkRep() {

        List<String> hashes = api.as(CLIENT).userSteps.imagesStepsV5().adImagesAdd(
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidRegularImage(7).getUrl())
                        .withName(ValidImageData.getValidRegularImage(7).getName())
        );

        api.as(CLIENT_REP).userSteps.imagesStepsV5().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap()
                                .withAdImageHashes(hashes.get(0))),
                AdImageExpectedResult.success()
        );
    }
}

