package ru.yandex.autotests.direct.api.adimages.delete;

import java.util.List;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannerImagesPoolRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageExpectedResult;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageHashesCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;


/**
 * Created by lightelfik on 30.05.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Description("Проверка удаления из базы изображений")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
@Features(AdImagesFeatures.DELETE)
@Tag(TagDictionary.TRUNK)
public class AdImagesDatabaseTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_DELETE;
    private static Long clientId;

    private List<String> hashes;

    private static DirectJooqDbSteps dbSteps;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        clientId = Long.parseLong(api.userSteps.clientFakeSteps().getClientData(CLIENT).getClientID());
        dbSteps = api.userSteps.getDarkSideSteps().getDirectJooqDbSteps().useShardForLogin(CLIENT);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
        hashes = api.as(CLIENT).userSteps.imagesStepsV5().adImagesAdd(
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidRegularImage(1).getUrl())
                        .withName(ValidImageData.getValidRegularImage(1).getName()),
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidRegularImage(4).getUrl())
                        .withName(ValidImageData.getValidRegularImage(4).getName())
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2341")
    public void checkDb() {
        String hash = hashes.get(0);

        api.userSteps.imagesStepsV5().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap()
                                .withAdImageHashes(hash)),
                AdImageExpectedResult.success()
        );

        BannerImagesPoolRecord imageRecord =
                dbSteps.bannerImagesPoolSteps().getBannerImagesPool(clientId, hash);

        assertThat("данных изображения нет в базе", imageRecord, nullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2343")
    public void checkDbForAssociateImage() {
        //DIRECT-53044
        String hash = hashes.get(1);

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withAdImageHash(hash))
                        .withAdGroupId(adGroupId)
        );

        api.userSteps.imagesStepsV5().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap()
                                .withAdImageHashes(hash)),
                AdImageExpectedResult.errors(new Notification(8301, Api5ErrorDetails.UNABLE_TO_DELETE_ASSOCIATED_IMAGE))
        );

        BannerImagesPoolRecord imageRecord =
                dbSteps.bannerImagesPoolSteps().getBannerImagesPool(clientId, hash);

        assertThat("изображение осталось в базе", imageRecord, notNullValue()
        );
    }
}
