package ru.yandex.autotests.direct.api.adimages.delete;

import org.junit.*;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageExpectedResult;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageHashesCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/**
 * Created by lightelfik on 10.05.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.DELETE)
@Description("Проверка доступа на удаление изображений для внутренних ролей")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
@RunWith(Parameterized.class)
public class AdImagesInternalRolesPositiveTest {
    private static String SERV_CLIENT = AdImagesLogins.SERV_GET_CLIENT;
    private String associatedHash;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(SERV_CLIENT);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
        List<String> hashes = api.as(SERV_CLIENT).userSteps.imagesStepsV5().adImagesAdd(
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidRegularImage(2).getUrl())
                        .withName(ValidImageData.getValidRegularImage(2).getName())
        );
        associatedHash = hashes.get(0);
    }

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameter(1)
    public AdImageExpectedResult expectedResult;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Logins.MANAGER_DEFAULT, AdImageExpectedResult.success()},
                {Logins.PLACER, AdImageExpectedResult.success()},
                {Logins.SUPPORT, AdImageExpectedResult.success()},
                {Logins.SUPER_LOGIN, AdImageExpectedResult.success()},
        };
        return Arrays.asList(data);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2347")
    public void checkRights() {

        api.as(loginForAuthorization).userSteps.imagesStepsV5().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap()
                                .withAdImageHashes(associatedHash)),
                SERV_CLIENT,
                expectedResult
        );
    }
}
