package ru.yandex.autotests.direct.api.adimages.delete;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageExpectedResult;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageHashesCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.DeleteRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;
import java.util.List;

import static org.apache.commons.lang.StringUtils.capitalize;

/**
 * Created by lightelfik on 10.05.16.
 * https://st.yandex-team.ru/TESTIRT-8445
 */
@Aqua.Test
@Features(AdImagesFeatures.DELETE)
@Description("Проверка лимита массива AdImageHash")
@Issue("https://st.yandex-team.ru/DIRECT-50157")
public class AdImagesLimitTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_DELETE_2;
    private List<String> hashes;


    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        hashes = api.userSteps.imagesStepsV5().addImagesForUserIfNotExists(CLIENT, 1);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2354")
    public void withMoreThanMaxHashesInSelectionCriteria() {
        String[] adImageHashes = new String[DeleteRequestMap.MAX_AMOUNT_OF_IMAGE_HASH_IN_DELETE_REQUEST + 1];
        Arrays.fill(adImageHashes, hashes.get(0));
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(
                                new AdImageHashesCriteriaMap()
                                        .withAdImageHashes(adImageHashes)
                        ),
                new Api5Error(4001,
                        Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                        capitalize(AdImageHashesCriteriaMap.AD_IMAGE_HASHES),
                        DeleteRequestMap.MAX_AMOUNT_OF_IMAGE_HASH_IN_DELETE_REQUEST
                )
        );
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2351")
    public void withMaxAdImageHashesInSelectionCriteria() {
        String[] adImageHashes = new String[DeleteRequestMap.MAX_AMOUNT_OF_IMAGE_HASH_IN_DELETE_REQUEST];
        Arrays.fill(adImageHashes, hashes.get(0));
        AdImageExpectedResult[] results =
                new AdImageExpectedResult[DeleteRequestMap.MAX_AMOUNT_OF_IMAGE_HASH_IN_DELETE_REQUEST];
        Arrays.fill(results, AdImageExpectedResult.errors(
                new Notification(9800, Api5ErrorDetails.IMAGE_HASH_IS_PRESENTED_MORE_THAN_ONCE_IN_REQUEST)
                )
        );
        api.userSteps.imagesStepsV5().shouldGetResultOnDelete(
                new DeleteRequestMap()
                        .withSelectionCriteria(
                                new AdImageHashesCriteriaMap()
                                        .withAdImageHashes(adImageHashes)
                        ),
                results
        );
    }
}
