package ru.yandex.autotests.direct.api.adimages.delete;

import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageExpectedResult;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageHashesCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.List;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by lightelfik on 30.05.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.DELETE)
@Description("Проверка работоспособности метода AdImageHash.delete по SOAP протоколу")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
public class AdImagesSOAPTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_DELETE;

    private List<String> hashes;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT).protocol(ProtocolType.SOAP);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
        hashes = api.as(CLIENT).userSteps.imagesStepsV5().adImagesAdd(
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidRegularImage(5).getUrl())
                        .withName(ValidImageData.getValidRegularImage(5).getName())
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2361")
    public void deleteOneValidAdImage() {

        api.userSteps.imagesStepsV5().shouldGetResultOnDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap()
                                .withAdImageHashes(hashes.get(0))),
                AdImageExpectedResult.success()
        );

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2358")
    public void emptyRequest() {
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(new DeleteRequestMap(),
                new Api5Error(8000,
                        Api5ErrorDetails.MISSING_REQUIRED_FIELD, "DeleteRequest",
                        capitalize(DeleteRequestMap.SELECTION_CRITERIA)
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2365")
    public void emptyAdImageHashes() {
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap()
                                .withAdImageHashes()
                ),
                new Api5Error(8000,
                        Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(DeleteRequestMap.SELECTION_CRITERIA),
                        capitalize(AdImageHashesCriteriaMap.AD_IMAGE_HASHES)
                ));
    }
}

