package ru.yandex.autotests.direct.api.adimages.delete;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageHashesCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.List;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by lightelfik on 12.05.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.DELETE)
@Description("Проверка правильности списания баллов")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
public class AdImagesUnitsTest {
    private static final String CLIENT = AdImagesLogins.CLIENT_DELETE_UNITS;
    private static final int CALL_COST = 10;
    private static final int AD_IMAGE_COST = 0;
    private static final int DEFAULT_ERROR_COST = 20;
    private static final int COMMON_REQUEST_ERROR = 50;

    private List<String> hashes;


    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
        hashes = api.userSteps.imagesStepsV5().addImagesForUserIfNotExists(CLIENT, 2);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2368")
    public void oneAdImage() {
        String hash = hashes.get(0);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);

        api.userSteps.imagesStepsV5().adImagesDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap()
                                .withAdImageHashes(hash)
                )
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + AD_IMAGE_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2369")
    public void twoAdImages() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);

        api.userSteps.imagesStepsV5().adImagesDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap()
                                .withAdImageHashes(hashes.get(0), hashes.get(1))
                )
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + (2 * AD_IMAGE_COST)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2366")
    public void oneAdImageWithError() {

        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);

        api.userSteps.imagesStepsV5().adImagesDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap()
                                .withAdImageHashes("")
                )
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + DEFAULT_ERROR_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2370")
    public void twoAdImageWithOneError() {
        String hash = hashes.get(0);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);

        api.userSteps.imagesStepsV5().adImagesDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap()
                                .withAdImageHashes("", hash)
                )
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + AD_IMAGE_COST + DEFAULT_ERROR_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2371")
    public void twoAdImageWithTwoError() {
        String hash = RandomStringUtils.randomAlphabetic(50);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);

        api.userSteps.imagesStepsV5().adImagesDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap()
                                .withAdImageHashes("", hash)
                )
        );

        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + 2 * DEFAULT_ERROR_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2367")
    public void adImageWithCommonError() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);

        api.userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(new DeleteRequestMap(),
                new Api5Error(8000,
                        Api5ErrorDetails.MISSING_REQUIRED_FIELD, "params",
                        capitalize(DeleteRequestMap.SELECTION_CRITERIA)
                ));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(CLIENT);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(COMMON_REQUEST_ERROR));
    }

}

