package ru.yandex.autotests.direct.api.adimages.delete;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageHashesCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import static org.apache.commons.lang3.StringUtils.capitalize;


/**
 * Created by lightelfik on 11.05.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.DELETE)
@Description("Проверка работоспособности в случае ошибки в запросе")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
public class AdImagesWrongRequest {
    private static final String CLIENT = AdImagesLogins.CLIENT_DELETE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String PARAMS = "params";

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2372")
    public void emptyRequest() {
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(new DeleteRequestMap(),
                new Api5Error(8000,
                        Api5ErrorDetails.MISSING_REQUIRED_FIELD, PARAMS,
                        capitalize(DeleteRequestMap.SELECTION_CRITERIA)
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2374")
    public void emptySelectionCriteria() {
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(
                new DeleteRequestMap().withSelectionCriteria(new AdImageHashesCriteriaMap()),
                new Api5Error(8000,
                        Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(DeleteRequestMap.SELECTION_CRITERIA),
                        capitalize(AdImageHashesCriteriaMap.AD_IMAGE_HASHES)
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2373")
    public void emptyAdImageHashes() {
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(
                new DeleteRequestMap().withSelectionCriteria(
                        new AdImageHashesCriteriaMap()
                                .withAdImageHashes()
                ),
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        capitalize(AdImageHashesCriteriaMap.AD_IMAGE_HASHES)
                ));
    }
}


