package ru.yandex.autotests.direct.api.adimages.delete;

import org.apache.commons.lang3.RandomStringUtils;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageHashesCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.DeleteRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import static org.apache.commons.lang3.StringUtils.capitalize;


/**
 * Created by lightelfik on 11.05.16.
 * https://st.yandex-team.ru/TESTIRT-9152
 */
@Aqua.Test
@Features(AdImagesFeatures.DELETE)
@Description("Проверка работоспособности в случае неправильного формата запроса")
@Issue("https://st.yandex-team.ru/DIRECT-47646")
public class AdImagesWrongRequestFormat {
    private static final String CLIENT = AdImagesLogins.CLIENT_DELETE;
    private static String hash;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String PARAMS = "params";

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        hash = RandomStringUtils.randomAlphabetic(22);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2375")
    public void invalidFieldInParams() {
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdImageHashesCriteriaMap.AD_IMAGE_HASHES),
                new String[]{hash});

        JSONObject request = new JSONObject();
        request.put(DeleteRequestMap.SELECTION_CRITERIA, selectionCriteria);

        api.userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(
                request,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_CONTAIN_UNKNOWN_FIELD,
                        PARAMS, DeleteRequestMap.SELECTION_CRITERIA
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2376")
    public void arrayInParams() {
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdImageHashesCriteriaMap.AD_IMAGE_HASHES),
                new String[]{hash});

        JSONObject request = new JSONObject();
        request.put(capitalize(DeleteRequestMap.SELECTION_CRITERIA), new Object[]{selectionCriteria});

        api.userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(
                new Object[]{request},
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY, PARAMS
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2382")
    public void invalidFieldInSelectionCriteria() {
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(AdImageHashesCriteriaMap.AD_IMAGE_HASHES,
                new String[]{hash});

        JSONObject request = new JSONObject();
        request.put(capitalize(DeleteRequestMap.SELECTION_CRITERIA), selectionCriteria);

        api.userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(
                request,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_CONTAIN_UNKNOWN_FIELD,
                        capitalize(DeleteRequestMap.SELECTION_CRITERIA), AdImageHashesCriteriaMap.AD_IMAGE_HASHES
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2377")
    public void arrayInSelectionCriteria() {
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdImageHashesCriteriaMap.AD_IMAGE_HASHES),
                new String[]{hash});

        JSONObject params = new JSONObject();
        params.put(capitalize(DeleteRequestMap.SELECTION_CRITERIA), new Object[]{selectionCriteria});

        api.userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(
                params,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(DeleteRequestMap.SELECTION_CRITERIA)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2378")
    public void nullInSelectionCriteria() {
        JSONObject request = new JSONObject();
        request.put(capitalize(DeleteRequestMap.SELECTION_CRITERIA), "null");

        api.userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(
                request,
                new Api5Error(8000,
                        Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(DeleteRequestMap.SELECTION_CRITERIA)
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2379")
    public void notArrayInAdImageHashes() {
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdImageHashesCriteriaMap.AD_IMAGE_HASHES), hash);

        JSONObject params = new JSONObject();
        params.put(capitalize(DeleteRequestMap.SELECTION_CRITERIA), selectionCriteria);

        api.userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(
                params,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(AdImageHashesCriteriaMap.AD_IMAGE_HASHES)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2380")
    public void nullInAdImageHashes() {
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdImageHashesCriteriaMap.AD_IMAGE_HASHES), "null");

        JSONObject request = new JSONObject();
        request.put(capitalize(DeleteRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(
                request,
                new Api5Error(8000,
                        Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(AdImageHashesCriteriaMap.AD_IMAGE_HASHES)
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2381")
    public void nullInAdImageHashesItem() {
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdImageHashesCriteriaMap.AD_IMAGE_HASHES), new String[]{null});

        JSONObject request = new JSONObject();
        request.put(capitalize(DeleteRequestMap.SELECTION_CRITERIA), selectionCriteria);
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesDelete(
                request,
                new Api5Error(8000,
                        Api5ErrorDetails.ELEMENT_OF_ARRAY_CANT_HAVE_NULL_VALUE,
                        capitalize(AdImageHashesCriteriaMap.AD_IMAGE_HASHES)
                ));
    }
}
