package ru.yandex.autotests.direct.api.adimages.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.adimages.AdImageFieldEnum;
import com.yandex.direct.api.v5.adimages.AdImageGetItem;
import com.yandex.direct.api.v5.adimages.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by ginger on 09.02.16.
 * https://st.yandex-team.ru/TESTIRT-8445
 */
@Aqua.Test
@Features(AdImagesFeatures.GET)
@Description("Проверка прав агентства к картинкам субклиентов")
@Issue("https://st.yandex-team.ru/DIRECT-50157")
@RunWith(Parameterized.class)
public class AdImagesAgencyCheckRightsTest {
    private static String client = AdImagesLogins.CLIENT_GET_10;
    private static String agency = AdImagesLogins.AGENCY;
    private static String agencyRep = AdImagesLogins.AGENCY_REP;
    private static String agencyRepCl = AdImagesLogins.AGENCY_REP_CL;
    private static String subclient = AdImagesLogins.SUBCLIENT;
    private static String subclientElse = AdImagesLogins.SUBCLIENT_ELSE;
    private static String associatedClientHash;
    private static String associatedSubclientHash;
    private static String associatedSubclientElseHash;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long clientAdId;
    static Long subclientAdId;
    static Long subclientElseAdId;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {agency},
                {agencyRep},
                {agencyRepCl}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void addImage() {
        associatedClientHash = api.as(client).userSteps.imagesStepsV5().adImagesAdd(
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidRegularImage(6).getUrl())
                        .withName(ValidImageData.getValidRegularImage(6).getName())
        ).get(0);
        associatedSubclientHash = api.as(agency).userSteps.imagesStepsV5().adImagesAdd(
                subclient,
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidRegularImage(4).getUrl())
                        .withName(ValidImageData.getValidRegularImage(4).getName())
        ).get(0);
        String[] hashes = api.userSteps.imagesSteps().configLoginImages(subclientElse, ImageType.REGULAR, 3);
        associatedSubclientElseHash = hashes[0];

        api.as(client);
        Long clientCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long clientAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(clientCampaignId);
        clientAdId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withAdImageHash(associatedClientHash))
                        .withAdGroupId(clientAdGroupId));
        api.as(agency);
        Long subclientCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        Long subclientAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(subclientCampaignId, subclient);
        subclientAdId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withAdImageHash(associatedSubclientHash))
                        .withAdGroupId(subclientAdGroupId), subclient);
        Long subclientElseCampaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subclientElse);
        Long subclientElseAdGroupId =
                api.userSteps.adGroupsSteps().addDefaultGroup(subclientElseCampaignId, subclientElse);
        subclientElseAdId = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withAdImageHash(associatedSubclientElseHash))
                        .withAdGroupId(subclientElseAdGroupId), subclientElse);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2383")
    public void callGetWithSubclientAdImage() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAssociated(YesNoEnum.YES)
                        )
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH),
                subclient
        );
        List<AdImageGetItem> adImages = response.getAdImages();
        assertThat("вернулась 1 картинка", adImages, beanEquivalent(
                Arrays.asList((AdImageGetItem) new AdImageGetItemMap().withAdImageHash(associatedSubclientHash).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2384")
    public void callGetWithSubclientElseAdImage() {
        GetResponse response = api.as(loginForAuthorization).userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(associatedSubclientElseHash)
                        )
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH),
                subclient
        );
        List<AdImageGetItem> adImages = response.getAdImages();
        assertThat("не вернулась картинка", adImages, hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2385")
    public void callGetWithAdImagesOfBothSubclients() {
        GetResponse response = api.as(loginForAuthorization).userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(associatedSubclientHash, associatedSubclientElseHash)
                        )
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH),
                subclient
        );
        List<AdImageGetItem> adImages = response.getAdImages();
        assertThat("вернулась 1 картинка", adImages, beanEquivalent(
                Arrays.asList((AdImageGetItem) new AdImageGetItemMap().withAdImageHash(associatedSubclientHash).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2386")
    public void callGetWithClientAdImage() {
        GetResponse response = api.as(loginForAuthorization).userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(associatedClientHash)
                        )
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH),
                subclient
        );
        List<AdImageGetItem> adImages = response.getAdImages();
        assertThat("не вернулась картинка", adImages, hasSize(0));
    }
}
