package ru.yandex.autotests.direct.api.adimages.get;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.adimages.AdImageFieldEnum;
import com.yandex.direct.api.v5.adimages.AdImageGetItem;
import com.yandex.direct.api.v5.adimages.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextImageAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer2.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 09.02.16.
 * https://st.yandex-team.ru/TESTIRT-8445
 */
@Aqua.Test
@Features(AdImagesFeatures.GET)
@Description("Проверка работы поля Associated")
@Issue("https://st.yandex-team.ru/DIRECT-50157")
public class AdImagesAssociatedTest {
    private static String client = AdImagesLogins.CLIENT_GET;
    private static String associatedRegularHash;
    private static String notAssociatedRegularHash;
    private static String associatedImageAdHash;
    private static String notAssociatedImageAdHash;

    private static Comparator<AdImageGetItem> comparator = (x, y) -> x.getAdImageHash().compareTo(y.getAdImageHash());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void addImage() {
        String[] hashes = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1, 2);
        associatedRegularHash = hashes[0];
        notAssociatedRegularHash = hashes[1];

        List<String> imageAdAdImageHashes = api.userSteps.imagesStepsV5().adImagesAdd(
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidImageAdImage(1).getUrl())
                        .withName(ValidImageData.getValidImageAdImage(1).getName()),
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidImageAdImage(2).getUrl())
                        .withName(ValidImageData.getValidImageAdImage(2).getName())
        );
        associatedImageAdHash = imageAdAdImageHashes.get(0);
        notAssociatedImageAdHash = imageAdAdImageHashes.get(1);

        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withAdImageHash(associatedRegularHash))
                        .withAdGroupId(adGroupId));
        api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextImageAd(
                                new TextImageAdAddMap()
                                        .defaultTextImageAd(associatedImageAdHash))
                        .withAdGroupId(adGroupId));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2387")
    public void getByYesAssociated() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAssociated(YesNoEnum.YES)
                        )
                        .withFieldNames(AdImageFieldEnum.ASSOCIATED, AdImageFieldEnum.AD_IMAGE_HASH)
        );
        List<AdImageGetItem> adImages = response.getAdImages();
        adImages.sort(comparator);
        assertThat("вернулись картинки с ожидаемыми параметрами", adImages, beanDiffer(
                Arrays.asList(
                        (AdImageGetItem) new AdImageGetItemMap()
                                .withAdImageHash(associatedRegularHash)
                                .withAssociated(YesNoEnum.YES)
                                .getBean(),
                        (AdImageGetItem) new AdImageGetItemMap()
                                .withAdImageHash(associatedImageAdHash)
                                .withAssociated(YesNoEnum.YES)
                                .getBean()).stream().sorted(comparator).collect(Collectors.toList())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2388")
    public void getByNoAssociated() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAssociated(YesNoEnum.NO)
                        )
                        .withFieldNames(AdImageFieldEnum.ASSOCIATED, AdImageFieldEnum.AD_IMAGE_HASH)
        );
        List<AdImageGetItem> adImages = response.getAdImages();
        adImages.sort(comparator);
        assertThat("вернулись картинки с ожидаемыми параметрами", adImages, beanDiffer(
                Arrays.asList(
                        (AdImageGetItem) new AdImageGetItemMap()
                                .withAdImageHash(notAssociatedRegularHash)
                                .withAssociated(YesNoEnum.NO)
                                .getBean(),
                        (AdImageGetItem) new AdImageGetItemMap()
                                .withAdImageHash(notAssociatedImageAdHash)
                                .withAssociated(YesNoEnum.NO)
                                .getBean()).stream().sorted(comparator).collect(Collectors.toList())));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2389")
    public void getByNullAssociated() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAssociated(null)
                        )
                        .withFieldNames(AdImageFieldEnum.ASSOCIATED, AdImageFieldEnum.AD_IMAGE_HASH)
        );
        List<AdImageGetItem> adImages = response.getAdImages();
        adImages.sort(comparator);
        assertThat("вернулись картинки с ожидаемыми параметрами", adImages,
                beanDiffer(
                        Arrays.asList(
                                (AdImageGetItem) new AdImageGetItemMap()
                                        .withAdImageHash(associatedRegularHash)
                                        .withAssociated(YesNoEnum.YES).getBean(),
                                (AdImageGetItem) new AdImageGetItemMap()
                                        .withAdImageHash(notAssociatedRegularHash)
                                        .withAssociated(YesNoEnum.NO).getBean(),
                                (AdImageGetItem) new AdImageGetItemMap()
                                        .withAdImageHash(associatedImageAdHash)
                                        .withAssociated(YesNoEnum.YES).getBean(),
                                (AdImageGetItem) new AdImageGetItemMap()
                                        .withAdImageHash(notAssociatedImageAdHash)
                                        .withAssociated(YesNoEnum.NO).getBean())
                                .stream().sorted(comparator).collect(Collectors.toList()))
        );
    }
}
