package ru.yandex.autotests.direct.api.adimages.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.adimages.AdImageFieldEnum;
import com.yandex.direct.api.v5.adimages.AdImageGetItem;
import com.yandex.direct.api.v5.adimages.AdImageSubtypeEnum;
import com.yandex.direct.api.v5.adimages.AdImageTypeEnum;
import com.yandex.direct.api.v5.adimages.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.banners.ImagesSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;

/**
 * Created by ginger on 09.02.16.
 * https://st.yandex-team.ru/TESTIRT-8445
 */
@Aqua.Test
@Features(AdImagesFeatures.GET)
@Description("Проверка соответствия возвращаемых полей, указанным в FieldNames")
@Issue("https://st.yandex-team.ru/DIRECT-50157")
public class AdImagesFieldNamesTest {

    private static String client = AdImagesLogins.CLIENT_GET_1;
    private String associatedHash;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
        String[] hashes = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1);
        associatedHash = hashes[0];
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withAdImageHash(associatedHash))
                        .withAdGroupId(adGroupId));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2390")
    public void successGetWithAllFieldNamesTest() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(associatedHash)
                                        .withAssociated(YesNoEnum.YES)
                        )
                        .withAllFieldNames()
        );
        assertThat("вернулась 1 картинка", response.getAdImages(), hasSize(1));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2395")
    public void successGetWithOnlyAdImageHashFieldNameTest() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(associatedHash)
                                        .withAssociated(YesNoEnum.YES)
                        )
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
        );
        assertThat("вернулась картинка с правильным AdImageHash", response.getAdImages(), beanDifferV5(
                Arrays.asList((AdImageGetItem) new AdImageGetItemMap()
                        .withAdImageHash(associatedHash).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2396")
    public void successGetWithOnlyAssociatedFieldNameTest() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(associatedHash)
                                        .withAssociated(YesNoEnum.YES)
                        )
                        .withFieldNames(AdImageFieldEnum.ASSOCIATED)
        );
        assertThat("вернулась картинка с правильным Associated", response.getAdImages(), beanDifferV5(
                Arrays.asList((AdImageGetItem) new AdImageGetItemMap()
                        .withAssociated(YesNoEnum.YES).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2391")
    public void successGetWithOnlyNameFieldNameTest() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(associatedHash)
                                        .withAssociated(YesNoEnum.YES)
                        )
                        .withFieldNames(AdImageFieldEnum.NAME)
        );
        assertThat("вернулась картинка с правильным Name", response.getAdImages(), beanDifferV5(
                Arrays.asList((AdImageGetItem) new AdImageGetItemMap()
                        .withName(ImagesSteps.nameValidRegularImages.get(1)).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2397")
    public void successGetWithOnlyOriginalUrlFieldNameTest() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(associatedHash)
                                        .withAssociated(YesNoEnum.YES)
                        )
                        .withFieldNames(AdImageFieldEnum.ORIGINAL_URL)
        );
        assertThat("вернулась картинка с правильным OriginalUrl",
                response.getAdImages().get(0).getOriginalUrl().getValue().contains(associatedHash),
                equalTo(true));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2392")
    public void successGetWithOnlyPreviewUrlFieldNameTest() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(associatedHash)
                                        .withAssociated(YesNoEnum.YES)
                        )
                        .withFieldNames(AdImageFieldEnum.PREVIEW_URL)
        );
        assertThat("вернулась картинка с правильным PreviewUrl",
                response.getAdImages().get(0).getPreviewUrl().getValue().contains(associatedHash),
                equalTo(true));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2393")
    public void successGetWithOnlyTypeFieldNameTest() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(associatedHash)
                                        .withAssociated(YesNoEnum.YES)
                        )
                        .withFieldNames(AdImageFieldEnum.TYPE)
        );
        assertThat("вернулась картинка с правильным Type", response.getAdImages(), beanDifferV5(
                Arrays.asList((AdImageGetItem) new AdImageGetItemMap()
                        .withType(AdImageTypeEnum.REGULAR).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2394")
    public void successGetWithOnlySubtypeFieldNameTest() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(associatedHash)
                                        .withAssociated(YesNoEnum.YES)
                        )
                        .withFieldNames(AdImageFieldEnum.SUBTYPE)
        );
        assertThat("вернулась картинка с правильным Type", response.getAdImages(), beanDifferV5(
                Arrays.asList((AdImageGetItem) new AdImageGetItemMap()
                        .withSubtype(AdImageSubtypeEnum.NONE).getBean())));
    }
}
