package ru.yandex.autotests.direct.api.adimages.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.adimages.AdImageFieldEnum;
import com.yandex.direct.api.v5.adimages.AdImageGetItem;
import com.yandex.direct.api.v5.adimages.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.hamcrest.MatcherAssert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by ginger on 09.02.16.
 * https://st.yandex-team.ru/TESTIRT-8445
 */
@Aqua.Test
@Features(AdImagesFeatures.GET)
@Description("Проверка доступа внутренних ролей к методу")
@Issue("https://st.yandex-team.ru/DIRECT-50157")
@RunWith(Parameterized.class)
public class AdImagesInternalRolesTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static String associatedHash;

    @Rule
    public Trashman trasher = new Trashman(api);

    private static String servClient = AdImagesLogins.SERV_GET_CLIENT;

    static Long adId;

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {Logins.MANAGER_DEFAULT},
                {Logins.PLACER},
                {Logins.SUPPORT},
                {Logins.SUPER_LOGIN},
                {Logins.MEDIA},
                {Logins.SUPER_READER}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createAd() {
        List<String> hashes = api.as(servClient).userSteps.imagesStepsV5().adImagesAdd(
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidRegularImage(5).getUrl())
                        .withName(ValidImageData.getValidRegularImage(5).getName())
        );
        associatedHash = hashes.get(0);
        Long campaignId = api.as(Logins.MANAGER_DEFAULT).userSteps.campaignSteps().addDefaultTextCampaign(servClient);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, servClient);
        api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withAdImageHash(associatedHash))
                        .withAdGroupId(adGroupId), servClient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2398")
    public void checkRightsToGet() {
        GetResponse response = api.as(loginForAuthorization).userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(associatedHash)
                                        .withAssociated(YesNoEnum.YES)
                        )
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH),
                servClient
        );
        List<AdImageGetItem> adImages = response.getAdImages();
        MatcherAssert.assertThat("вернулась 1 ожидаемая картинка", adImages, beanEquivalent(
                Arrays.asList((AdImageGetItem) new AdImageGetItemMap().withAdImageHash(associatedHash).getBean())));
    }
}
