package ru.yandex.autotests.direct.api.adimages.get;

import com.yandex.direct.api.v5.adimages.AdImageFieldEnum;
import org.json.simple.JSONObject;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;

/**
 * Created by ginger on 09.02.16.
 * https://st.yandex-team.ru/TESTIRT-8445
 */
@Aqua.Test
@Features(AdImagesFeatures.GET)
@Description("Проверка валидации JSON структуры")
@Issue("https://st.yandex-team.ru/DIRECT-50157")
public class AdImagesInvalidJsonTest {
    private static String client = AdImagesLogins.CLIENT_GET_2;
    public String PARAMS = "params";
    public String unknownField = "gingerField";
    private String associatedHash;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
        String[] hashes = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1);
        associatedHash = hashes[0];
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withAdImageHash(associatedHash))
                        .withAdGroupId(adGroupId));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2399")
    public void tryGetWithSelectionCriteriaArray() {
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdImageSelectionCriteriaMap.AD_IMAGE_HASHES),
                new String[]{associatedHash});
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA),new Object[]{selectionCriteria});
        params.put(capitalize(GetRequestMap.FIELD_NAMES),new String[]{AdImageFieldEnum.AD_IMAGE_HASH.value()});
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesGet(
                params,
                client,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(GetRequestMap.SELECTION_CRITERIA)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2400")
    public void tryGetWithEmptyArrayOfFieldNames(){
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdImageSelectionCriteriaMap.AD_IMAGE_HASHES),
                new String[]{associatedHash});
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        params.put(capitalize(GetRequestMap.FIELD_NAMES),new String[]{});
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesGet(
                params,
                client,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        capitalize(GetRequestMap.FIELD_NAMES),
                        1
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2401")
    public void tryGetWithFieldNamesNotArray(){
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdImageSelectionCriteriaMap.AD_IMAGE_HASHES),
                new String[]{associatedHash});
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        params.put(capitalize(GetRequestMap.FIELD_NAMES),AdImageFieldEnum.ASSOCIATED);
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesGet(
                params,
                client,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(GetRequestMap.FIELD_NAMES)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2402")
    public void unknownFieldInRequest(){
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdImageSelectionCriteriaMap.AD_IMAGE_HASHES),
                new String[]{associatedHash});
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        params.put(capitalize(GetRequestMap.FIELD_NAMES),new AdImageFieldEnum[]{AdImageFieldEnum.AD_IMAGE_HASH});
        params.put(unknownField,":)");
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesGet(
                params,
                client,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_CONTAIN_UNKNOWN_FIELD,
                        PARAMS,
                        unknownField
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2403")
    public void tryAdImageHashesNotArray(){
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdImageSelectionCriteriaMap.AD_IMAGE_HASHES),
                associatedHash);
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        params.put(capitalize(GetRequestMap.FIELD_NAMES),new AdImageFieldEnum[]{AdImageFieldEnum.AD_IMAGE_HASH});
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesGet(
                params,
                client,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(AdImageSelectionCriteriaMap.AD_IMAGE_HASHES)
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2404")
    public void unknownFieldInSelectionCriteria(){
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdImageSelectionCriteriaMap.AD_IMAGE_HASHES),
                new String[]{associatedHash});
        selectionCriteria.put(unknownField,":)");
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        params.put(capitalize(GetRequestMap.FIELD_NAMES),new AdImageFieldEnum[]{AdImageFieldEnum.AD_IMAGE_HASH});
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesGet(
                params,
                client,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_CONTAIN_UNKNOWN_FIELD,
                        capitalize(GetRequestMap.SELECTION_CRITERIA),
                        unknownField
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2405")
    public void unknownFieldInFieldNames(){
        JSONObject selectionCriteria = new JSONObject();
        selectionCriteria.put(capitalize(AdImageSelectionCriteriaMap.AD_IMAGE_HASHES),
                new String[]{associatedHash});
        JSONObject params = new JSONObject();
        params.put(capitalize(GetRequestMap.SELECTION_CRITERIA), selectionCriteria);
        params.put(capitalize(GetRequestMap.FIELD_NAMES),new String[]{AdImageFieldEnum.AD_IMAGE_HASH.value(),"gingerField"});
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesGet(
                params,
                client,
                new Api5Error(8000,
                        Api5ErrorDetails.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(GetRequestMap.FIELD_NAMES)
                )
        );
    }
}
