package ru.yandex.autotests.direct.api.adimages.get;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by ginger on 10.02.16.
 * https://st.yandex-team.ru/TESTIRT-8445
 */
@Aqua.Test
@Features(AdImagesFeatures.GET)
@Description("Проверка вызова метода без обязательных полей")
@Issue("https://st.yandex-team.ru/DIRECT-50157")
@RunWith(Parameterized.class)
public class AdImagesInvalidRequestTest {
    private static String client = AdImagesLogins.CLIENT_GET_3;
    public static String PARAMS =  "params";
    private String associatedHash;
    private Long campaignID;
    private Long adGroupID;
    private Long adID;

    @Parameterized.Parameter(0)
    public ProtocolType protocol;

    @Parameterized.Parameter(1)
    public Api5Error expectedError;

    @Parameterized.Parameters(name = "protocol = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {ProtocolType.JSON, new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD, PARAMS,
                        capitalize(GetRequestMap.FIELD_NAMES))},
                {ProtocolType.SOAP, new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD, GetRequestMap.GET_REQUEST,
                        capitalize(GetRequestMap.FIELD_NAMES))}
        };
        return Arrays.asList(data);
    }
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
        String[] hashes = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1);
        associatedHash = hashes[0];
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        adID = api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withAdImageHash(associatedHash))
                        .withAdGroupId(adGroupID));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2406")
    public void getWithEmptyParams() {
        GetRequestMap params = new GetRequestMap();
        api.protocol(protocol).userSteps.imagesStepsV5().expectErrorOnAdImagesGet(
                params,
                expectedError
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2407")
    public void getWithEmptyFieldNamesTest() {
        GetRequestMap params = new GetRequestMap().withSelectionCriteria(null);
        api.protocol(protocol).userSteps.imagesStepsV5().expectErrorOnAdImagesGet(
                params,
                expectedError
        );
    }

}
