package ru.yandex.autotests.direct.api.adimages.get;

import com.yandex.direct.api.v5.adimages.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;

import static org.apache.commons.lang.StringUtils.capitalize;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.hasSize;

/**
 * Created by ginger on 09.02.16.
 * https://st.yandex-team.ru/TESTIRT-8445
 */
@Aqua.Test
@Features(AdImagesFeatures.GET)
@Description("Проверка лимита массива AdImageHash")
@Issue("https://st.yandex-team.ru/DIRECT-50157")
public class AdImagesLimitTest {
    private static String client = AdImagesLogins.CLIENT_GET_4;
    private String[] hashes;


    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
        hashes = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1);
    }

    @Issue("DIRECT-51052")
    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2409")
    public void getWithMoreThanMaxHashesInSelectionCriteria() {
        String[] adImageHashes = new String[GetRequestMap.MAX_AMOUNT_OF_IMAGE_HASH_IN_GET_REQUEST+1];
        Arrays.fill(adImageHashes, hashes[0]);
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(adImageHashes)
                        )
                        .withAllFieldNames(),
                client,
                new Api5Error(4001,
                        Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                        capitalize(AdImageSelectionCriteriaMap.AD_IMAGE_HASHES),
                        GetRequestMap.MAX_AMOUNT_OF_IMAGE_HASH_IN_GET_REQUEST
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2408")
    public void getWithMaxAdImageHashesInSelectionCriteria(){
        String[] adImageHashes = new String[GetRequestMap.MAX_AMOUNT_OF_IMAGE_HASH_IN_GET_REQUEST];
        Arrays.fill(adImageHashes, hashes[0]);
        GetResponse getResponse =  api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(adImageHashes)
                        )
                        .withAllFieldNames(),
                client
        );
        assertThat("вернулось правильное кол-во AdImageHashes",getResponse.getAdImages(), hasSize(1));
    }
}
