package ru.yandex.autotests.direct.api.adimages.get;

import com.yandex.direct.api.v5.adimages.AdImageFieldEnum;
import com.yandex.direct.api.v5.adimages.GetResponse;
import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageGetItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;
import java.util.List;

import static ch.lambdaj.Lambda.extractProperty;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.nullValue;

/**
 * Created by ginger on 09.02.16.
 * https://st.yandex-team.ru/TESTIRT-8445
 */
@Aqua.Test
@Features(AdImagesFeatures.GET)
@Description("Проверка пагинации в методе Get")
@Issue("https://st.yandex-team.ru/DIRECT-50157")
public class AdImagesPagerTest {
    private static String client = AdImagesLogins.CLIENT_GET_5;
    private static String anotherClient = AdImagesLogins.CLIENT_FREE_YE_DEFAULT;
    private static String[] hashes;
    private static String anotherClientHashes;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void addImage() {
        hashes = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1, 2, 3, 4);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2411")
    public void getHead() {
        GetResponse getResponse = api.userSteps.imagesStepsV5().adImagesGet(new GetRequestMap()
                .withSelectionCriteria(new AdImageSelectionCriteriaMap().withAdImageHashes(hashes))
                .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                .withPage(new LimitOffsetMap()
                        .withLimit(2l)
                        .withOffset(0l)));
        List<Long> gotIds = extractProperty(getResponse.getAdImages(), AdImageGetItemMap.AD_IMAGE_HASH);
        assertThat("вернулся правильный набор картинок", gotIds, equalTo(Arrays.asList(hashes[0], hashes[1])));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2412")
    public void getBody() {
        GetResponse getResponse = api.userSteps.imagesStepsV5().adImagesGet(new GetRequestMap()
                .withSelectionCriteria(new AdImageSelectionCriteriaMap().withAdImageHashes(hashes))
                .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                .withPage(new LimitOffsetMap()
                        .withLimit(2l)
                        .withOffset(1l)));
        List<Long> gotIds = extractProperty(getResponse.getAdImages(), AdImageGetItemMap.AD_IMAGE_HASH);
        assertThat("вернулся правильный набор картинок", gotIds, equalTo(Arrays.asList(hashes[1], hashes[2])));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2410")
    public void getTail() {
        GetResponse getResponse = api.userSteps.imagesStepsV5().adImagesGet(new GetRequestMap()
                .withSelectionCriteria(new AdImageSelectionCriteriaMap().withAdImageHashes(hashes))
                .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                .withPage(new LimitOffsetMap()
                        .withLimit(2l)
                        .withOffset(2l)));
        List<Long> gotIds = extractProperty(getResponse.getAdImages(), AdImageGetItemMap.AD_IMAGE_HASH);
        assertThat("вернулся правильный набор картинок", gotIds, equalTo(Arrays.asList(hashes[2], hashes[3])));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2413")
    public void getPartOfTail() {
        GetResponse getResponse = api.userSteps.imagesStepsV5().adImagesGet(new GetRequestMap()
                .withSelectionCriteria(new AdImageSelectionCriteriaMap().withAdImageHashes(hashes))
                .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                .withPage(new LimitOffsetMap()
                        .withLimit(2l)
                        .withOffset(3l)));
        List<Long> gotIds = extractProperty(getResponse.getAdImages(), AdImageGetItemMap.AD_IMAGE_HASH);
        assertThat("вернулся правильный набор картинок", gotIds, equalTo(Arrays.asList(hashes[3])));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2414")
    public void getOverTail() {
        GetResponse getResponse = api.userSteps.imagesStepsV5().adImagesGet(new GetRequestMap()
                .withSelectionCriteria(new AdImageSelectionCriteriaMap().withAdImageHashes(hashes))
                .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                .withPage(new LimitOffsetMap()
                        .withLimit(2l)
                        .withOffset(4l)));
        assertThat("вернулся правильный набор картинок", getResponse.getAdImages(), hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2415")
    public void onlyLimit() {
        GetResponse getResponse = api.userSteps.imagesStepsV5().adImagesGet(new GetRequestMap()
                .withSelectionCriteria(new AdImageSelectionCriteriaMap().withAdImageHashes(hashes))
                .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                .withPage(new LimitOffsetMap()
                        .withLimit(2l)));
        List<Long> gotIds = extractProperty(getResponse.getAdImages(), AdImageGetItemMap.AD_IMAGE_HASH);
        assertThat("вернулся правильный набор картинок", gotIds, equalTo(Arrays.asList(hashes[0], hashes[1])));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2416")
    public void onlyOffset() {
        GetResponse getResponse = api.userSteps.imagesStepsV5().adImagesGet(new GetRequestMap()
                .withSelectionCriteria(new AdImageSelectionCriteriaMap().withAdImageHashes(hashes))
                .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                .withPage(new LimitOffsetMap()
                        .withOffset(2l)));
        List<Long> gotIds = extractProperty(getResponse.getAdImages(), AdImageGetItemMap.AD_IMAGE_HASH);
        assertThat("вернулся правильный набор картинок", gotIds, equalTo(Arrays.asList(hashes[2], hashes[3])));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2417")
    public void zeroLimit() {
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesGet(new GetRequestMap()
                        .withSelectionCriteria(new AdImageSelectionCriteriaMap().withAdImageHashes(hashes))
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                        .withPage(new LimitOffsetMap()
                                .withLimit(0l)),
                new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2418")
    public void negativeLimit() {
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesGet(new GetRequestMap()
                        .withSelectionCriteria(new AdImageSelectionCriteriaMap().withAdImageHashes(hashes))
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                        .withPage(new LimitOffsetMap()
                                .withLimit(-1l)),
                new Api5Error(4002, Api5ErrorDetails.LIMIT_MUST_BE_MORE_THAN_0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2419")
    public void maxLimit() {
        GetResponse getResponse = api.userSteps.imagesStepsV5().adImagesGet(new GetRequestMap()
                .withSelectionCriteria(new AdImageSelectionCriteriaMap().withAdImageHashes(hashes))
                .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                .withPage(new LimitOffsetMap()
                        .withLimit(LimitOffsetMap.LIMIT_MAX_LENGTH)));
        List<Long> gotIds = extractProperty(getResponse.getAdImages(), AdImageGetItemMap.AD_IMAGE_HASH);
        assertThat("вернулся правильный набор картинок", gotIds, equalTo(Arrays.asList(hashes)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2420")
    public void overMaxLimit() {
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesGet(new GetRequestMap()
                        .withSelectionCriteria(new AdImageSelectionCriteriaMap().withAdImageHashes(hashes))
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                        .withPage(new LimitOffsetMap()
                                .withLimit(LimitOffsetMap.LIMIT_MAX_LENGTH + 1)),
                new Api5Error(4002, Api5ErrorDetails.LIMIT_CANNOT_BE_MORE, LimitOffsetMap.LIMIT_MAX_LENGTH));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2421")
    public void negativeOffset() {
        api.userSteps.imagesStepsV5().expectErrorOnAdImagesGet(new GetRequestMap()
                        .withSelectionCriteria(new AdImageSelectionCriteriaMap().withAdImageHashes(hashes))
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                        .withPage(new LimitOffsetMap()
                                .withOffset(-1l)),
                new Api5Error(4002, Api5ErrorDetails.OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2422")
    public void checkLimitedByIfLimitDidntWork() {
        GetResponse getResponse = api.userSteps.imagesStepsV5().adImagesGet(new GetRequestMap()
                .withSelectionCriteria(new AdImageSelectionCriteriaMap().withAdImageHashes(hashes))
                .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                .withPage(new LimitOffsetMap()
                        .withLimit(4l)));
        assertThat("значение LimitedBy верно", getResponse.getLimitedBy(), nullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2423")
    public void checkLimitedByIfLimitWorked() {
        GetResponse getResponse = api.userSteps.imagesStepsV5().adImagesGet(new GetRequestMap()
                .withSelectionCriteria(new AdImageSelectionCriteriaMap().withAdImageHashes(hashes))
                .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                .withPage(new LimitOffsetMap()
                        .withLimit(2l)));
        assertThat("значение LimitedBy верно", getResponse.getLimitedBy(), equalTo(2l));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2424")
    public void checkLimitedByIfLimitWorkedWithOffset() {
        GetResponse getResponse = api.userSteps.imagesStepsV5().adImagesGet(new GetRequestMap()
                .withSelectionCriteria(new AdImageSelectionCriteriaMap().withAdImageHashes(hashes))
                .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
                .withPage(new LimitOffsetMap()
                        .withOffset(1l)
                        .withLimit(2l)));
        assertThat("значение LimitedBy верно", getResponse.getLimitedBy(), equalTo(3l));
    }
}
