package ru.yandex.autotests.direct.api.adimages.get;

import java.util.List;

import com.yandex.direct.api.v5.adimages.AdImageFieldEnum;
import com.yandex.direct.api.v5.adimages.AdImageGetItem;
import com.yandex.direct.api.v5.adimages.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 10.02.16.

 * https://st.yandex-team.ru/TESTIRT-8445
 */
@Aqua.Test
@Features(AdImagesFeatures.GET)
@Description("Получение картинок клиента с помощью фильтрации в SelectionCriteria")
@Issue("https://st.yandex-team.ru/DIRECT-50157")
public class AdImagesSelectionCriteriaTest {
    private static String client = AdImagesLogins.CLIENT_GET_6;
    private static String associatedHash;
    private static String notAssociatedHash;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void addImage() {
        String[] hashes = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1, 2);
        associatedHash = hashes[0];
        notAssociatedHash = hashes[1];
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withAdImageHash(associatedHash))
                        .withAdGroupId(adGroupId));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2425")
    public void getAllImagesWithEmptySelectionCriteriaTest() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(null)
                        .withAllFieldNames()
        );
        List<AdImageGetItem> adImages = response.getAdImages();
        assertThat("вернулись 2 картинки клиента", adImages, hasSize(equalTo(2)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2426")
    public void getImagesByImageHashTest() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(associatedHash, notAssociatedHash)
                        )
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
        );
        List<AdImageGetItem> adImages = response.getAdImages();
        assertThat("вернулись 2 картинки клиента", adImages, hasSize(equalTo(2)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2427")
    public void getImagesByNotAssociatedImageHashTest() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                    .withAdImageHashes(notAssociatedHash)
                        )
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
        );
        List<AdImageGetItem> adImages = response.getAdImages();
        assumeThat("вернулась 1 картинка", adImages, hasSize(equalTo(1)));
        assertThat("получен ожидаемый AdImageHash", adImages.get(0).getAdImageHash(), equalTo(notAssociatedHash));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2428")
    public void getImagesByAssociatedImageHashTest() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(associatedHash)
                        )
                        .withFieldNames(AdImageFieldEnum.AD_IMAGE_HASH)
        );
        List<AdImageGetItem> adImages = response.getAdImages();
        assumeThat("вернулась 1 картинка", adImages, hasSize(equalTo(1)));
        assertThat("получен ожидаемый AdImageHash", adImages.get(0).getAdImageHash(), equalTo(associatedHash));
    }
}
