package ru.yandex.autotests.direct.api.adimages.get;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.adimages.AdImageGetItem;
import com.yandex.direct.api.v5.adimages.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageAddItemMap;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;

/**
 * Created by ginger on 09.02.16.
 * https://st.yandex-team.ru/TESTIRT-8445
 */
@Aqua.Test
@Features(AdImagesFeatures.GET)
@Description("Проверка шардирования метода")
@Issue("https://st.yandex-team.ru/DIRECT-50157")
@RunWith(Parameterized.class)
public class AdImagesShardingTest {
    private static String agency = AdImagesLogins.AGENCY;
    private static String subclientIn1Shard = AdImagesLogins.SUBCL_1_SHARD;
    private static String subclientIn2Shard = AdImagesLogins.SUBCL_2_SHARD;

    private String associatedHash;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(agency);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String subclient;

    @Parameterized.Parameters(name = "subclient = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {subclientIn1Shard},
                {subclientIn2Shard},

        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void reshardUsers() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(agency, ShardNumbers.EXTRA_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientIn1Shard, ShardNumbers.DEFAULT_SHARD);
        api.userSteps.clientFakeSteps().reshardUserWithLock(subclientIn2Shard, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
        associatedHash = api.as(agency).userSteps.imagesStepsV5().adImagesAdd(
                subclient,
                new AdImageAddItemMap()
                        .withImageData(ValidImageData.getValidRegularImage(3).getUrl())
                        .withName(ValidImageData.getValidRegularImage(3).getName())
        ).get(0);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, subclient);
        api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withAdImageHash(associatedHash))
                        .withAdGroupId(adGroupId), subclient);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2429")
    public void successGetTest() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(associatedHash)
                                        .withAssociated(YesNoEnum.YES)
                        )
                        .withAllFieldNames(),
                subclient
        );
        List<AdImageGetItem> adImages = response.getAdImages();
        assertThat("вернулась 1 картинка", adImages, hasSize(equalTo(1)));
    }
}
