package ru.yandex.autotests.direct.api.adimages.get;

import java.util.List;

import com.yandex.direct.api.v5.adimages.AdImageGetItem;
import com.yandex.direct.api.v5.adimages.GetResponse;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;

/**
 * Created by ginger on 16.16.16.
 * https://st.yandex-team.ru/TESTIRT-8445
 */
@Aqua.Test
@Features(AdImagesFeatures.SMOKE)
@Description("Smoke test для поля AdImageHash")
@Issue("https://st.yandex-team.ru/DIRECT-50157")
public class AdImagesSmokeAdImageHashTest {
    private static String client = AdImagesLogins.CLIENT_GET_11;
    private String associatedHash;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
        String[] hashes = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1);
        associatedHash = hashes[0];
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addAd(
                new AdAddItemMap()
                        .withTextAd(
                                new TextAdAddMap()
                                        .defaultTextAd()
                                        .withAdImageHash(associatedHash))
                        .withAdGroupId(adGroupId));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2430")
    public void successGetTest() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                            new AdImageSelectionCriteriaMap()
                                .withAdImageHashes(associatedHash)
                                .withAssociated(YesNoEnum.YES)
                        )
                        .withAllFieldNames()
        );
        List<AdImageGetItem> adImages = response.getAdImages();
        assertThat("вернулась 1 картинка", adImages, hasSize(equalTo(1)));
    }
}
