package ru.yandex.autotests.direct.api.adimages.get;

import com.yandex.direct.api.v5.adimages.AdImageFieldEnum;
import com.yandex.direct.api.v5.adimages.AdImageSubtypeEnum;
import com.yandex.direct.api.v5.adimages.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Image;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 25.07.16.
 * https://st.yandex-team.ru/TESTIRT-9781
 */
@Aqua.Test
@Features(AdImagesFeatures.GET)
@Description("Проверка вывода поля Subtype")
@Issue("https://st.yandex-team.ru/DIRECT-56042")
@RunWith(Parameterized.class)
public class AdImagesSubtypeTest {

    private static String client = AdImagesLogins.CLIENT_GET_12;
    private String[] hashes;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public List<Image> images;

    @Parameterized.Parameter(2)
    public List<AdImageSubtypeEnum> subtypes;

    @Parameterized.Parameters(name = "imageType = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"regular", Arrays.asList(ValidImageData.getValidRegularImage(1)),
                        Arrays.asList(AdImageSubtypeEnum.NONE)},
                {"wide", Arrays.asList(ValidImageData.getValidWideImage(1)),
                        Arrays.asList(AdImageSubtypeEnum.NONE)},
                {"fixed image 240x400", Arrays.asList(ValidImageData.getValidImageAdImage(1)),
                        Arrays.asList(AdImageSubtypeEnum.IMG_240_400)},
                {"fixed image 728x90", Arrays.asList(ValidImageData.getValidImageAdImage(2)),
                        Arrays.asList(AdImageSubtypeEnum.IMG_728_90)},
                {"fixed image 300x250", Arrays.asList(ValidImageData.getValidImageAdImage(4)),
                        Arrays.asList(AdImageSubtypeEnum.IMG_300_250)},
                {"fixed image 300x600", Arrays.asList(ValidImageData.getValidImageAdImage(7)),
                        Arrays.asList(AdImageSubtypeEnum.IMG_300_600)},
                {"fixed image 336x280", Arrays.asList(ValidImageData.getValidImageAdImage(8)),
                        Arrays.asList(AdImageSubtypeEnum.IMG_336_280)},
                {"fixed image 300x500", Arrays.asList(ValidImageData.getValidImageAdImage(9)),
                        Arrays.asList(AdImageSubtypeEnum.IMG_300_500)},
                {"fixed image 970x250", Arrays.asList(ValidImageData.getValidImageAdImage(10)),
                        Arrays.asList(AdImageSubtypeEnum.IMG_970_250)},
                {"fixed image 640x100", Arrays.asList(ValidImageData.getValidImageAdImage(11)),
                        Arrays.asList(AdImageSubtypeEnum.IMG_640_100)},
                {"fixed image 640x200", Arrays.asList(ValidImageData.getValidImageAdImage(12)),
                        Arrays.asList(AdImageSubtypeEnum.IMG_640_200)},
                {"fixed image 640x960", Arrays.asList(ValidImageData.getValidImageAdImage(13)),
                        Arrays.asList(AdImageSubtypeEnum.IMG_640_960)},
                {"fixed image 960x640", Arrays.asList(ValidImageData.getValidImageAdImage(14)),
                        Arrays.asList(AdImageSubtypeEnum.IMG_960_640)},
                {"all subtypes",
                        Arrays.asList(ValidImageData.getValidRegularImage(1),
                                ValidImageData.getValidWideImage(1),
                                ValidImageData.getValidImageAdImage(1),
                                ValidImageData.getValidImageAdImage(2),
                                ValidImageData.getValidImageAdImage(4),
                                ValidImageData.getValidImageAdImage(7),
                                ValidImageData.getValidImageAdImage(8),
                                ValidImageData.getValidImageAdImage(9),
                                ValidImageData.getValidImageAdImage(10),
                                ValidImageData.getValidImageAdImage(11),
                                ValidImageData.getValidImageAdImage(12),
                                ValidImageData.getValidImageAdImage(13),
                                ValidImageData.getValidImageAdImage(14)),
                        Arrays.asList(AdImageSubtypeEnum.NONE,
                                AdImageSubtypeEnum.NONE,
                                AdImageSubtypeEnum.IMG_240_400,
                                AdImageSubtypeEnum.IMG_728_90,
                                AdImageSubtypeEnum.IMG_300_250,
                                AdImageSubtypeEnum.IMG_300_600,
                                AdImageSubtypeEnum.IMG_336_280,
                                AdImageSubtypeEnum.IMG_300_500,
                                AdImageSubtypeEnum.IMG_970_250,
                                AdImageSubtypeEnum.IMG_640_100,
                                AdImageSubtypeEnum.IMG_640_200,
                                AdImageSubtypeEnum.IMG_640_960,
                                AdImageSubtypeEnum.IMG_960_640)},

        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
        hashes = images.stream().map(image -> api.userSteps.imagesStepsV5().addImage(image)).toArray(String[]::new);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2431")
    public void getExpectedSubtypesTest() {
        //DIRECT-56530
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(hashes)
                        )
                        .withFieldNames(AdImageFieldEnum.SUBTYPE)
        );
        List<AdImageSubtypeEnum> gotOutputSubtypes = response.getAdImages().stream()
                .map(adImage -> adImage.getSubtype())
                .collect(Collectors.toList());
        assertThat("вернулись ожидаемые сабтипы картинок", gotOutputSubtypes, beanDiffer(subtypes));
    }
}
