package ru.yandex.autotests.direct.api.adimages.get;

import com.yandex.direct.api.v5.adimages.AdImageFieldEnum;
import com.yandex.direct.api.v5.adimages.AdImageTypeEnum;
import com.yandex.direct.api.v5.adimages.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.adimages.AdImagesFeatures;
import ru.yandex.autotests.direct.api.adimages.AdImagesLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Image;
import ru.yandex.autotests.directapi.model.ValidImageData;
import ru.yandex.autotests.directapi.model.api5.adimages.AdImageSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.adimages.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 09.02.16.
 * https://st.yandex-team.ru/TESTIRT-8445
 */
@Aqua.Test
@Features(AdImagesFeatures.GET)
@Description("Проверка вывода поля Type")
@Issue("https://st.yandex-team.ru/DIRECT-50157")
@RunWith(Parameterized.class)
public class AdImagesTypeTest {
    private static String client = AdImagesLogins.CLIENT_GET_7;
    private String[] hashes;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public List<AdImageTypeEnum> types;

    @Parameterized.Parameters(name = "imageType = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"regular", Arrays.asList(AdImageTypeEnum.REGULAR)},
                {"wide", Arrays.asList(AdImageTypeEnum.WIDE)},
                {"fixed image", Arrays.asList(AdImageTypeEnum.FIXED_IMAGE)},
                {"regular, wide, fixed image", Arrays.asList(AdImageTypeEnum.REGULAR, AdImageTypeEnum.WIDE, AdImageTypeEnum.FIXED_IMAGE)}

        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void addImage() {
        hashes = new String[types.size()];
        for (int i = 0; i < types.size(); i++) {
            Image image = ValidImageData.getValidImageByType(types.get(i), i + 1);
            hashes[i] = api.userSteps.imagesStepsV5().addImage(image);
        }
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2432")
    public void getExpectedTypeTest() {
        GetResponse response = api.userSteps.imagesStepsV5().adImagesGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new AdImageSelectionCriteriaMap()
                                        .withAdImageHashes(hashes)
                        )
                        .withFieldNames(AdImageFieldEnum.TYPE)
        );
        List<AdImageTypeEnum> gotOutputTypes = response.getAdImages().stream()
                .map(adImage -> adImage.getType())
                .collect(Collectors.toList());
        assertThat("вернулись ожидаемые типы картинок",
                gotOutputTypes, beanDiffer(types));
    }
}
